      PROGRAM TARSOX_EST
C===================================================================
C===================================================================
C     Program for fitting TARSO models or TARSC models.
C     Thresholds are allowed in the X variable.
C     Version made by Martin Knotters, November 1996 - January 1997.
C
C Purpose:
C
C (A) : Estimation of AR-parameters, given the threshold values, the 
C       delay and the AR-orders and lags;
C (B) : Simulation of output data given observed input data;
C (C) : Validation of simulation results with an independent validation
C       set of observed output;
C (D) : Estimation of the uncertainty of the threshold values being
C       fitted, by a bootstrap procedure.
C
C Symbols:
C
C X : 2 dimensional array storing the data;
C NO : full length of data;
C NRCHK : number of data chopped at the end of the series 
C         for the purpose of calculating one step ahead pre-
C         diction and comparison;
C ITRANS : code for transformation;
C NEFF : number of eventual forecasting function;
C IDM : user-supplied delay of X and Y;
C THD : user-supplied threshold values of X and Y;
C NTHD : number of thresholds.
C
C Remarks:
C 1. This program can handle the ordinary transfer function model.
C    If the program is used in this way, we recommend that
C    several options may be set as follows:
C    Choose for model calibration with user-supplied threshold;
C    Number of thresholds = 0;
C    Delay = 0.
C 2. This program can also handle univariate SETAR-modelling:
C    Choose the same file for X-data and Y-data;
C    Choose AR-orders 0 for Y-variable.
C
C Restrictions of the program:
C Number of data <= 1000;
C Number of data in any piece not greater than 500;
C In particular, if NTHD=1, the number of data has to be not greater
C than 500;
C Maximum number of threshold values = 4;
C Maximum lag <= 20;
C Max number of predictions, EFF <= 1000.
C
C===================================================================
C===================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      REAL*8 MAIC, IPL, IPU
      DIMENSION X(2,1000),XR(2,1000),THD(2,4),VAV(2,5),THDD(2,4)
      DIMENSION CMATX(2,5,32),ICMATX(2,5),THDXX(4),XMY(1000)
      DIMENSION NTHD(2),ID1(2),ID2(2),N0(2),N(2),NRCHK(2),NEFF(2)
      DIMENSION IDM(2),ITRANS(2),NLREG(2),CMA(5,50)
      DIMENSION BX(2),S(2),TAICM(2),XX(1000),YY(1000),ICM(50)
      DIMENSION CTHD(2,140),Y(1002),VPH(10000,4),VPHQ(4,7)
      DIMENSION IX(1000),VALUE(50)
      DIMENSION CKY(1000),YYCKY(1002),MAIC(2)
      DIMENSION IARX(2,5),IARY(2,5),ILAGX(2,50,5),ILAGY(2,50,5)
      DIMENSION RES(2,1000),RDN(2,1000),RSDN(2,1000),NE(2)
      DIMENSION TTHD(2,4,10000),SUM(2,4),SETHR(2,4),THRGEM(2,4)
      DIMENSION SV(1000,2),SVREL(1000,1000),SARR(1000)
      DIMENSION ELN(1000),ANORM(5),SVQ(1000,7)
      DIMENSION XVAL(1000),SVF(800000),XSORT(1000),T1(1000),T2(1000)
      DIMENSION V1(1000),V2(1000),V3(1000)
      DATA P1,P2,P3,P4,P5,P6,P7/0.025,0.05,0.25,0.5,0.75,0.95,0.975/
      INTEGER IELN(1000),ANSWER,THR
      LOGICAL L
      CHARACTER*80 FILE2,FILE3,FILE4,FILE5,FILE6,FILE7
      COMMON /MAXMIN/AMAX,AMIN
C+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C     Reading the input:
C+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C
C.....Read data from datafiles:
C
      WRITE(6,*)' ONE SERIES (= 1) OR TWO SERIES (= 2) : '
      READ(5,*) ANSWER
C
      DO 9400 JXY=1,2
      NMAX=1000
      EOF=9.9**10
C
 700  CONTINUE
      IF (JXY.EQ.1) THEN
         WRITE(6,'(A)')'  Give the name of the file containing'
         WRITE(6,'(A)')'  data on the output Y (TARSOY.DAT):  '
         READ(5,'(A)') FILE3
         IF (FILE3.EQ.' ') THEN
            FILE3='TARSOY.DAT'
         END IF
c         OPEN(10,FILE=FILE3)
         OPEN(10,FILE=FILE3,STATUS='OLD',READONLY)
      ELSE
         IF(ANSWER.EQ.1) THEN
            FILE4=FILE3
c            OPEN(11,FILE=FILE4)
            OPEN(11,FILE=FILE4,STATUS='OLD',READONLY)
            GOTO 9500
         ELSE        
         WRITE(6,'(A)')'  Give the name of the file containing'
         WRITE(6,'(A)')'  data on the input X (TARSOX.DAT):  '
         READ(5,'(A)') FILE4
         IF (FILE4.EQ.' ') THEN
            FILE4='TARSOX.DAT'
         END IF
c         OPEN(11,FILE=FILE4)
         OPEN(11,FILE=FILE4,STATUS='OLD',READONLY)
         ENDIF
9500     CONTINUE
      ENDIF
C
      DO 121 I=1,NMAX
      X(JXY,I)=EOF
121   CONTINUE
      IF (JXY.EQ.1) THEN
         READ(10,*,END=131) (X(JXY,I),I=1,NMAX)
      ELSE
         READ(11,*,END=131) (X(JXY,I),I=1,NMAX)
      ENDIF
131   CONTINUE
      N0(JXY)=0
      DO 141 I=1,NMAX
      IF(X(JXY,I).EQ.EOF) GO TO 171
      N0(JXY)=N0(JXY)+1
141   CONTINUE
171   CONTINUE
         IF (JXY .EQ. 1) THEN
         WRITE(6,*)' Code for transforming the Y-data:  '
         ELSE
             IF (ANSWER .EQ. 2) THEN
                 WRITE(6,*)' Code for transforming the X-data: '
             ELSE 
                 ITRANS(2)=ITRANS(1)
                 NRCHK(2)=NRCHK(1)
                 GOTO 7223
             ENDIF
         ENDIF
         WRITE(6,*)' No transformation     (1): '
         WRITE(6,*)' Square root           (2): '
         WRITE(6,*)' Log to base 10        (3): '
         WRITE(6,*)' Log to base E         (4): '
         WRITE(6,*)' Exp transformation    (5): '
         WRITE(6,*)' Square transformation (6): '
         WRITE(6,*)' 2*(SQRT(XT+1)-1)      (7): '
         WRITE(6,*)' First difference      (8): '
         WRITE(6,*)' Difference of LOG    (9): '
         WRITE(6,*)' 1000*(LOG10*X-7)     (10): '
         WRITE(6,*)' 1000*(LOG10*X)       (11): '
         WRITE(6,*)' Type your choice: '
         READ(5,*) ITRANS(JXY)
         WRITE(6,*)' No. of data chopped off ( 0 ?): '
         READ(5,*) NRCHK(JXY)
 7223    CONTINUE
         N(JXY)=N0(JXY)-NRCHK(JXY)
         IF (ITRANS(JXY) .NE. 8) GOTO 7222
         NJXY=N(JXY)
         DO 7224 KY=1,N0C
 7224    XMY(KY)=X(JXY,KY)
         CALL DIFF1(NJXY,N0C,XMY)
         N(JXY)=NJXY
         N0(JXY)=N0C
         DO 7225 KY=1,N0C
 7225    X(JXY,KY)=XMY(KY)
 7222    CONTINUE
 9400 CONTINUE
         IF (N0(1).NE.N0(2)) THEN
            WRITE(6,*)' X and Y series must be of equal length!'
            WRITE(6,*)' Program stopped.'
            GOTO 111
         ENDIF
      WRITE(6,'(A)')'  Give the name of the output file (tarso.out):  '
      READ(5,'(A)') FILE2
      IF (FILE2.EQ.' ') THEN
         FILE2='TARSO.OUT'
      ENDIF
      WRITE(6,*)'  Give number of data'
      WRITE(6,*)'  to skip in start calibration: '
      READ(5,*) ISK
 701  CONTINUE
c      OPEN(9,FILE=FILE2)
      OPEN(9,FILE=FILE2,STATUS='NEW')
      WRITE(9,7197)
 7197 FORMAT(' RESULTS OF TARSO-MODELLING WITH USER-SUPPL.THRESHOLDS.')
      WRITE(9,7198)
 7198 FORMAT(/' Program MKT17K, M. Knotters and J.G. de Gooijer, 1997.')
      WRITE(6,*)
      WRITE(9,*)' TARSO/SETAR ANALYSIS FOR  ', ANSWER , ' SERIES '
      WRITE(6,*)
      WRITE(9,7199) (X(1,I),I=1,N0(1))
 7199 FORMAT(//' Y data (full length without transformation ) : '/
     1(' ',7F10.3))
      IF(ANSWER.EQ.1) GOTO 7201
      WRITE(9,7200) (X(2,I),I=1,N0(1))
 7200 FORMAT(/' X data (full length without transformation ) : '/
     1(' ',7F10.3))
 7201 CONTINUE 
      WRITE(9,7202)ITRANS(1),ITRANS(2)
 7202 FORMAT(/' Transformation of Y = ',I2,
     1', transformation of X = ',I2)
      WRITE(9,*)' No transformation     (1)'
      WRITE(9,*)' Square root           (2)'
      WRITE(9,*)' Log to base 10        (3)'
      WRITE(9,*)' Log to base E         (4)'
      WRITE(9,*)' Exp transformation    (5)'
      WRITE(9,*)' Square transformation (6)'
      WRITE(9,*)' 2*(SQRT(XT+1)-1)      (7)'
      WRITE(9,*)' First difference      (8)'
      WRITE(9,*)' Difference of LOG    (9)'
      WRITE(9,*)' 1000*(LOG10*X-7)     (10)'
      WRITE(9,*)' 1000*(LOG10*X)       (11)'
      WRITE(9,7203)NRCHK(1),NRCHK(2)
 7203 FORMAT(//' Number of Y-data chopped off: ',I3,/
     1' Number of X-data chopped off: ',I3,//)
C
C*****M. Knotters, 3-4-1997*****
      IF (ANSWER.EQ.2) THEN
         WRITE(6,*)' Open-loop or closed-loop system (1 or 2)? '
         READ(5,*) MODEL
         WRITE(9,6464) MODEL
 6464    FORMAT('  MODEL = ',I5,'      TARSO IS 1   TARSC IS 2 '//)
      ELSE
         MODEL=1
      ENDIF
C*******************************
C.....Set IFORCE = 1: Model estimation with user-suppied thresholds
C
      IFORCE=1
 7301 WRITE(6,*)' Selection by AIC (1), corrected AIC (2) or BIC (3)? '
      READ(5,*)ISEL
      IF (ISEL .LT. 1 .OR. ISEL .GT. 3) THEN
         WRITE(6,*)' Choose 1, 2 or 3!!! '
         GOTO 7301
      ENDIF
C.....MKY = model key word
      DO 7400 MKY=1,MODEL
         WRITE(9,9601)MKY
 9601    FORMAT(' Model key = ',I1)
         WRITE(9,9602)N0(MKY)
 9602    FORMAT(' Number of data = ',I5)
         ID1(MKY)=0
         WRITE(6,*)' Give no. of thresholds (0 <= NTHD <= 4):  '
         READ(5,*) NTHD(MKY)
         THR=NTHD(MKY)
         WRITE(6,*)' Give the delay: '
         READ(5,*) IDM(MKY)
         WRITE(9,7343)IDM(MKY)
 7343    FORMAT(/' Delay for thresholds = ',I3)
         NT=NTHD(MKY)
         DO 8401 I=1,NT
                 WRITE(6,8400)I
 8400            FORMAT(/'  Give the ',I2,'th threshold value:  ')
                 READ(5,*)THD(MKY,I)
 8401    CONTINUE
         WRITE(9,7300)(THD(MKY,I),I=1,NT)
 7300    FORMAT(/' Thresholds: ',4F10.4)
         WRITE(6,*)' Number of eventual forecasting function:  '
         READ(5,*) NEFF(MKY)
         NREG=NTHD(MKY)+1
         WRITE(6,*)' TARSO=1, TARSC=2 :',MKY
         DO 7403 I=1,NREG
        WRITE(6,*)' Give the AR-order of the Y-terms for region ',I,': '
            READ(5,*)IARX(MKY,I)
            WRITE(9,8300)MKY,I,IARX(MKY,I)
 8300       FORMAT(/' Model key = ',I2,/' Piece = ',I2,/
     1      ' AR-order of Y-terms = ',I3)
            DO 7401 ITEL=1,IARX(MKY,I)
               WRITE(6,*)' Give the lag for Y-term ',ITEL,': '
               READ(5,*)ILAGX(MKY,ITEL,I)
               WRITE(9,8301)ITEL,ILAGX(MKY,ITEL,I)
 8301          FORMAT(' Lag for ',I2,'th AR-parameter of Y: ',I2)
 7401       CONTINUE
          IF (ANSWER.EQ.1) GOTO 7403
        WRITE(6,*)' Give the AR-order of the X-terms for region ',I,': '
            READ(5,*)IARY(MKY,I)
            WRITE(9,8302)MKY,I,IARY(MKY,I)
 8302       FORMAT(/' Model key = ',I2,/' Piece = ',I2,/
     1      ' AR-order of X-terms = ',I3)
            DO 7402 ITEL=1,IARY(MKY,I)
               WRITE(6,*)' Give the lag for X-term ',ITEL,': '
               READ(5,*)ILAGY(MKY,ITEL,I)
               WRITE(9,8303)ITEL,ILAGY(MKY,ITEL,I)
 8303          FORMAT(' Lag for ',I2,'th AR-parameter of X: ',I2)
 7402       CONTINUE
 7403    CONTINUE
 7400 CONTINUE
C++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C     Transform data:
C++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      CALL TRANS(X,X,N0,ITRANS,N)
C
C++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C     Model estimation with user-supplied threshold
C++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      L=.FALSE.
      DO 4 J=1,1
      K1=1
      K2=2
      CALL RAIC(X,N,THD,NTHD,IDM,VAV,CMATX,ICMATX,TAICM,L,
     *MODEL,ISEL,IARX,IARY,ILAGX,ILAGY,RES,RDN,NE,IES,ANORM,ISK,MAXAR)
      IF (MODEL.EQ.2) GOTO 299
      WRITE(6,*)' You can choose for simulation with open-loop models. '
      WRITE(6,*)' Simulation with fitted model (1=yes, 0=no)? '
      READ(5,*)IANS
      IF (IANS.EQ.0) GOTO 299
C+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C     Simulation procedure for open loop models.
C+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C     Start of simulation procedure. The program needs a file
C     with data on the input variable and the mean value of the
C     output variable in the calibration period (for purposes of
C     initialization). Furthermore, the user is asked for a seed
C     value which is used in resampling from the fitted residuals.
      NS=N(1)
      RMEAN=0
      DO 298 IS=1,NS
         R1=X(1,IS)/NS
         RMEAN=RMEAN+R1
  298 CONTINUE
      IF (ANSWER .EQ. 2) THEN
         WRITE(6,'(A)')'  Give the name of the file containing'
         WRITE(6,'(A)')'  data on the input X (TARSOX.SIM):  '
         READ(5,'(A)') FILE6
         IF (FILE6.EQ.' ') THEN
            FILE6='TARSOX.SIM'
         END IF
c         OPEN(13,FILE=FILE6)
         OPEN(13,FILE=FILE6,STATUS='OLD',READONLY)
         DO 297 ISV=1,NMAX
            SV(ISV,2)=EOF
  297    CONTINUE
         READ(13,*,END=296) (SV(ISW,2),ISW=1,NMAX)
C.....The second column of SV contains the observed input. The 
C.....first column of SV will be filled with the simulated output.
  296    CONTINUE
         NSIM=0
         DO 295 I=1,NMAX
         IF(SV(I,2).EQ.EOF) GO TO 294
C.....The length of the simulated series is NSIM (minus starting
C.....values IES-1, see subroutine SIMULA) :
         NSIM=NSIM+1
295      CONTINUE
294      CONTINUE
      ELSE
C.....In case of a SETAR model the length of the simulated series
C.....is 1000 (minus starting values IES-1, see subroutine SIMULA) :
         NSIM=1000
      ENDIF
      WRITE(6,*)' Give a seed: '
      READ(5,*) SSIM
      WRITE(9,6789)SSIM
 6789 FORMAT(' Seed in start simulation = ',f10.0)
C.....The number of simulated realizations is 1000:
      NCOLS=1000
C      NULL=0
      DO 7777 I=1,NCOLS
      CALL SIMULA(RMEAN,SV,THD,NTHD,IDM,IARX,IARY,ILAGX,ILAGY,
     *CMATX,NSIM,IES,SSIM,RES,ANORM,NS)
         DO 7778 II=1,NSIM

            SVREL(II,I)=SV(II,1)
            IF (SV(II,1).GT.0.) THEN 
C               NULL=NULL+1
                SVREL(II,I)=0.
            ENDIF
 7778    CONTINUE
 7777 CONTINUE
      PRINT*,'NULL=',NULL
C.....Calculate quantiles of generated realizations:
      DO 6677 IJ1=1,NSIM
         DO 7766 IJ2=1,NCOLS
            SARR(IJ2)=SVREL(IJ1,IJ2)
 7766    CONTINUE
         CALL QCKSRT(NCOLS,SARR)
         CALL PERCEN(P1,SARR,1000,PERC)
         SVQ(IJ1,1)=PERC
         CALL PERCEN(P2,SARR,1000,PERC)
         SVQ(IJ1,2)=PERC
         CALL PERCEN(P3,SARR,1000,PERC)
         SVQ(IJ1,3)=PERC
         CALL PERCEN(P4,SARR,1000,PERC)
         SVQ(IJ1,4)=PERC
         CALL PERCEN(P5,SARR,1000,PERC)
         SVQ(IJ1,5)=PERC
         CALL PERCEN(P6,SARR,1000,PERC)
         SVQ(IJ1,6)=PERC
         CALL PERCEN(P7,SARR,1000,PERC)
         SVQ(IJ1,7)=PERC
C         IP=NINT(0.025*NCOLS)
C         SVQ(IJ1,1)=SARR(IP)
C         IP=NINT(0.05*NCOLS)
C         SVQ(IJ1,2)=SARR(IP)
C         IP=NINT(0.25*NCOLS)
C         SVQ(IJ1,3)=SARR(IP)
C         IP=NINT(0.5*NCOLS)
C         SVQ(IJ1,4)=SARR(IP)
C         IP=NINT(0.75*NCOLS)
C         SVQ(IJ1,5)=SARR(IP)
C         IP=NINT(0.95*NCOLS)
C         SVQ(IJ1,6)=SARR(IP)
C         IP=NINT(0.975*NCOLS)
C         SVQ(IJ1,7)=SARR(IP)
 6677 CONTINUE
      WRITE(9,*)' Quantiles simulated series: '
      WRITE(9,*)' 0.025, 0.05, 0.25, 0.5, 0.75, 0.95, 0.975 '
      DO 6678 IJ3=1,NSIM
         WRITE(9,6679)(SVQ(IJ3,IJV),IJV=1,7)
 6679    FORMAT(7F10.4)
 6678 CONTINUE
C.....Calculate the means of the mean error, the root mean square error and
C     the median absolute error for the validation period and the calibration
C     period. It is assumed that these periods are part of the simulation
C     period.
         WRITE(6,'(A)')'  Give the name of the file containing'
         WRITE(6,'(A)')'  the validation set (TARSOX.VAL):  '
         READ(5,'(A)') FILE7
         IF (FILE7.EQ.' ') THEN
            FILE7='TARSOX.VAL'
         END IF
c         OPEN(14,FILE=FILE7)
         OPEN(14,FILE=FILE7,STATUS='OLD',READONLY)
         DO 9297 ISV=1,NMAX
            XVAL(ISV)=EOF
 9297    CONTINUE
         READ(14,*,END=9296) (XVAL(ISW),ISW=1,NMAX)
 9296    CONTINUE
         NVAL=0
         DO 9295 I=1,NMAX
         IF(XVAL(I).EQ.EOF) GO TO 9294
         NVAL=NVAL+1
 9295    CONTINUE
 9294    CONTINUE
 9298 WRITE(6,*)' Give the starts and the ends of '
      WRITE(6,*)' the validation period and the calibration period. '
      WRITE(6,*)' The simulation period is from t=1 to ',NSIM,' . '
      WRITE(6,*)' Start validation period: '
      READ(5,*) ISV
      WRITE(6,*)' End validation period: '
      READ(5,*) IEV
      NVAL1=IEV-ISV+1
      IF (NVAL1 .NE. NVAL) THEN
         WRITE(6,*)' Start and end of validation period do not '
         WRITE(6,*)' match the length of the validation series! '
         GOTO 9298
      ENDIF
 9299 WRITE(6,*)' Start calibration period: '
      READ(5,*) ISC
      WRITE(6,*)' End calibration period: '
      READ(5,*) IEC
      NCAL1=IEC-ISC+1
      NCAL=N0(1)
      IF (NCAL1 .NE. NCAL) THEN
         WRITE(6,*)' Start and end of calibration period do not '
         WRITE(6,*)' match the length of the calibration series! '
         GOTO 9299
      ENDIF
      RME=0
      RMAE=0
      RMSE=0
      ICOUNT=0
      DO 6680 J1=1,NCOLS
         RMEV=0
         RMAEV=0
         RMSEV=0
         NV2=0
         IPOL=0
         DO 6681 I=ISV,IEV
C.....Check on the presence of missing values (labeled as 999.):
            IF (XVAL(I-ISV+1) .LT. 999.) THEN
               XD=XVAL(I-ISV+1)-SVREL(I,J1)
               RMEV=RMEV+XD
               RMAEV=RMAEV+ABS(XD)
               RMSEV=RMSEV+(XD*XD)
               IF (XVAL(I-ISV+1) .LT. SVQ(I,1)) IPOL=IPOL+1 
               IF (XVAL(I-ISV+1) .GT. SVQ(I,7)) IPOL=IPOL+1
               NV2=NV2+1
            ENDIF
         ICOUNT=ICOUNT+1
         SVF(ICOUNT)=SVREL(I,J1)
 6681    CONTINUE
      RME=RME+RMEV/NV2
      V1(J1)=RMEV/NV2
      RMSE=RMSE+SQRT(RMSEV/NV2)
      RMSE1=RMSE1+RMSEV/NV2
      V2(J1)=SQRT(RMSEV/NV2)
      RMAE=RMAE+RMAEV/NV2
      V3(J1)=RMAEV/NV2
 6680 CONTINUE
      RME=RME/NCOLS
      RMSE=RMSE/NCOLS
      RMSE1=SQRT(RMSE1/NCOLS)
      RMAE=RMAE/NCOLS
      SD1=0.
      SD2=0.
      SD3=0.
      DO 7000 I=1,1000
         SD1=SD1+(RME-V1(I))**2
         SD2=SD2+(RMSE-V2(I))**2
         SD3=SD3+(RMAE-V3(I))**2
 7000 CONTINUE
      SD1=SQRT(SD1/1000)
      SD2=SQRT(SD2/1000)
      SD3=SQRT(SD3/1000)
      WRITE(9,*)' VALIDATION PERIOD : '
      WRITE(9,*)' MEAN ERROR = ',RME
      WRITE(9,*)' S.E. = ',SD1
      WRITE(9,*)' ROOT MEAN SQUARE ERROR 1 = ',RMSE
      WRITE(9,*)' S.E. = ',SD2
      WRITE(9,*)' ROOT MEAN SQUARE ERROR 2 = ',RMSE1
      WRITE(9,*)' MEAN ABSOLUTE ERROR = ',RMAE
      WRITE(9,*)' S.E. = ',SD3
      WRITE(9,*)' NUMBER OF OBS. OUTSIDE 95 % CONF. LIMITS = ',IPOL
      POL=DBLE(IPOL*DBLE(100./NV2))
      WRITE(9,*)' PERCENTAGE = ',POL
      RME=0
      RMAE=0
      RMSE=0
      DO 6682 J1=1,NCOLS
         RMEV=0
         RMAEV=0
         RMSEV=0
         NV2=0
         IPOL=0
         DO 6683 I=ISC,IEC
C.....Check on the presence of missing values (labeled as 999.):
            IF (X(1,I-ISC+1) .LT. 999.) THEN
               XD=X(1,I-ISC+1)-SVREL(I,J1)
               RMEV=RMEV+XD
               RMAEV=RMAEV+ABS(XD)
               RMSEV=RMSEV+(XD*XD)
               IF (X(1,I-ISC+1) .LT. SVQ(I,1)) IPOL=IPOL+1 
               IF (X(1,I-ISC+1) .GT. SVQ(I,7)) IPOL=IPOL+1
               NV2=NV2+1
            ENDIF
 6683    CONTINUE
      RME=RME+RMEV/NV2
      V1(J1)=RMEV/NV2
      RMSE=RMSE+SQRT(RMSEV/NV2)
      V2(J1)=SQRT(RMSEV/NV2)
      RMAE=RMAE+RMAEV/NV2
      V3(J1)=RMAEV/NV2
 6682 CONTINUE
      RME=RME/NCOLS
      RMSE=RMSE/NCOLS
      RMAE=RMAE/NCOLS
      SD1=0.
      SD2=0.
      SD3=0.
      DO 7001 I=1,1000
         SD1=SD1+(RME-V1(I))**2
         SD2=SD2+(RMSE-V2(I))**2
         SD3=SD3+(RMAE-V3(I))**2
 7001 CONTINUE
      SD1=SQRT(SD1/1000)
      SD2=SQRT(SD2/1000)
      SD3=SQRT(SD3/1000)
      WRITE(9,*)' CALIBRATION PERIOD : '
      WRITE(9,*)' MEAN ERROR = ',RME
      WRITE(9,*)' S.E. = ',SD1
      WRITE(9,*)' ROOT MEAN SQUARE ERROR = ',RMSE
      WRITE(9,*)' S.E. = ',SD2
      WRITE(9,*)' MEAN ABSOLUTE ERROR = ',RMAE
      WRITE(9,*)' S.E. = ',SD3
      WRITE(9,*)' NUMBER OF OBS. OUTSIDE 95 % CONF. LIMITS = ',IPOL
      POL=DBLE(IPOL*DBLE(100./NV2))
      WRITE(9,*)' PERCENTAGE = ',POL
  299 CONTINUE
C++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C     Estimation of the uncertainty of the threshold values by a 
C     bootstrap procedure.
C     1) Resampling of normalized residuals RES;
C     2) Denormalization using RDN;
C     3) Addition of realization of residuals to observations on X-variable;
C     4) Search the threshold values by rough identification, RIDENT, for 
C        fixed AR-orders, delays and numbers of thresholds;
C     5) Store the threshold values;
C     6) Repeat (1) to (4) N times (N is large).
C++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      WRITE(6,*)' Start bootstrap procedure.'
      WRITE(6,*)' Give a large number of realizations to be generated: '
      READ(5,*) NREL
      IF (NREL.EQ.0) GOTO 7999
      WRITE(9,5432)NREL
 5432 FORMAT(' Number of bootstrap replications = ',I10)
      WRITE(6,*)' Give the percentiles in between the thresolds '
      WRITE(6,*)' will be searched. Lower percentile : '
      READ(5,*) IPL
      WRITE(9,*)' Lower percentile = ',IPL
      WRITE(6,*)' Upper percentile : '
      READ(5,*) IPU
      WRITE(9,*)' Upper percentile = ',IPU
C.....The program uses a maximum number of AR-parameters for a variable
C     in subroutine SORT, in order to calculate the minimum number of 
C     data in a regime. The maximum number of AR-parameters is equal 
C     to the number of values to be skipped in the start of the 
C     calibration period.
      MAXAR=ISK
      WRITE(6,'(A)')'  Give the name of the output file '
      WRITE(6,'(A)')'  with replications of thresholds (BOOTSTR.OUT):  '
      READ(5,'(A)') FILE5
      IF (FILE5.EQ.' ') THEN
         FILE5='BOOTSTR.OUT'
      ENDIF
 943  CONTINUE
c      OPEN(8,FILE=FILE5)
      OPEN(8,FILE=FILE5,STATUS='NEW')
      WRITE(6,*)' Give a seed: '
      READ(5,*) SEED
      WRITE(9,9876)SEED
 9876 FORMAT(' Seed = ',f10.0)
      DO 31 L1=1,MODEL
         NEL=NE(L1)
         DO 21 I=1,NREL
            CALL DURAND(SEED,NEL,ELN)
            IESM=IES-1
            DO 9444 JZJ=1,IESM
               XR(1,JZJ)=X(L1,JZJ)
               XR(2,JZJ)=X(2,JZJ)
 9444       CONTINUE
            DO 9441 JXJ=IES,N(L1)
               III=JXJ-IES+1
               IELN(III) = 1+INT(NEL*ELN(III))
C.....Add denormalized residuals to the observations:
               RSDN(L1,III)=RES(L1,IELN(III))*RDN(L1,III)
               XR(1,JXJ) = X(L1,JXJ)+RSDN(L1,III)
C.....XR is a realization of X for a TARSO model of given orders and delay.
C***************************************************************************
C     XR(1,JXJ) is set 0 if the water-table depth reaches the groundsurface!
C***************************************************************************
               IF (XR(1,JXJ).GT.0.) THEN
                  XR(1,JXJ)=0.
               ENDIF
               XR(2,JXJ) = X(2,JXJ)
c               WRITE(9,9443)X(L1,JXJ),XR(1,JXJ),XR(2,JXJ),RSDN(L1,III),
c     1         RDN(L1,III),IELN(III)
c 9443          FORMAT(5F12.4,I5)
 9441       CONTINUE
C.....XR is submitted to the subroutine RIDENT to select a threshold value.
C.....Rough identification is executed.
            IFORCE=0
            N1=N(1)
            DO 9340 IJ=1,N1
 9340          CKY(IJ)=XR(1,IJ)
            CALL DESACF(N1,CKY,1.0,BX(1),S(1),0)
            AMAX=BX(1)+5.*S(1)
            AMIN=BX(1)-5.*S(1)
            N2=N(2)
            DO 9350 IJ=1,N2
 9350         CKY(IJ)=XR(2,IJ)
            CALL DESACF(N2,CKY,1.0,BX(2),S(2),0)
C******Martin Knotters, April 1997. Candidate threshold values are
C      searched at intervals of 1 in between the 10th and the 90th
C      percentile of the empirical distribution of the output variable.
C      Subroutine PCAND.
c            CALL CAND(XR,N1,CTHD,IPL,IPU)
            CALL PCAND(XR,N1,CTHD,IPL,IPU)
            IFDUM=1
            CALL RIDENT(XR,N,THDD,NTHD,CTHD,ID1,ID2,IDM,MAIC,VAV,CMATX,
     1      ICMATX,MODEL,ISEL,IARX,IARY,ILAGX,ILAGY,IFDUM,ISK,MAXAR)
            WRITE(8,9351) (THDD(L1,IZ),IZ=1,THR)
 9351       FORMAT(4F10.4)
         DO 20 IZ=1,THR
         VPH(I,IZ)=THDD(L1,IZ)
C         WRITE(*,*) 'BOOTSTR. REP. & THRESH = ', I,IZ
   20    CONTINUE
   21    CONTINUE
   31 CONTINUE
C
      DO 41 IZ=1,THR
      CALL QTHETA (VPH,VPHQ,NREL,THR)
C*****CALCULATE THE QUANTILES OF A SAMPLE *************
c
      WRITE(9,*)
      WRITE(9,*)' THRESHOLD NUMBER = ', IZ
      WRITE(9,*)' 0.025 quantile = ',vphq(IZ,1)
      WRITE(9,*)' 0.05  quantile = ',vphq(IZ,2)
      WRITE(9,*)' 0.25  quantile = ',vphq(IZ,3)
      WRITE(9,*)' 0.5   quantile = ',vphq(IZ,4)
      WRITE(9,*)' 0.75  quantile = ',vphq(IZ,5)
      WRITE(9,*)' 0.95  quantile = ',vphq(IZ,6)
      WRITE(9,*)' 0.975 quantile = ',vphq(IZ,7)
 41   CONTINUE
 7999 CONTINUE
C
C++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C     Frequency of exceedance curve
C++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C
C     1. Frequency of exceedance curve of the data in the calibration
C        period:
      WRITE(9,*)' FOE-curve data in validation period: '
      JXS=0
      DO 8000 I=1,NVAL
         IF (XVAL(I) .LT. 999.) THEN
            JXS=JXS+1
            XSORT(JXS)=XVAL(I)
         ENDIF
 8000 CONTINUE
      CALL QCKSRT(JXS,XSORT)
      DO 8001 I=1,JXS
         T1(I) = DBLE(I*365)/JXS
         T2(I) = XSORT(JXS+1-I)
         WRITE(9,'(2F12.6)') T1(I),T2(I)
 8001 CONTINUE
C     2. Frequency of exceedance curve of the simulations:
      WRITE(9,*)' FOE-curve simulations in validation period: '
      CALL QCKSRT(ICOUNT,SVF)
      DO 8002 I=1,JXS
         TX = T1(I)
         TY = T2(I)
         DO 8003 JT=1,ICOUNT-1
            TT1=DBLE((ICOUNT+1-JT)*365)/DBLE(ICOUNT)
            TT2=DBLE((ICOUNT-JT)*365)/DBLE(ICOUNT)
            IF ((TX .LE. TT1) .AND. (TX .GT. TT2)) THEN
               TZ = (SVF(JT) + SVF(JT+1))/2.
               WRITE(9,'(3F12.6)')TX,TY,TZ
               GOTO 8004
            ENDIF
 8003    CONTINUE
 8004 CONTINUE
 8002 CONTINUE
      DO 500 MKY=1,MODEL
      IES=IDM(MKY)
      IEND=NTHD(MKY)+1
      NK1=N0(K1)
      NK2=N0(K2)
      DO 300 L2=1,NK1
  300 XX(L2)=X(K1,L2)
      DO 310 L2=1,NK2
  310 YY(L2)=X(K2,L2)
      NXX=N(MKY)
      NRCHKX=NRCHK(MKY)
      THDXX(1)=THD(MKY,1)
      NTHDX=NTHD(MKY)
      IDMX=IDM(MKY)
      DO 320 L2=1,5
      DO 320 L3=1,32
  320 CMA(L2,L3)=CMATX(MKY,L2,L3)
      DO 323 L2=1,5
  323 ICM(L2)=ICMATX(MKY,L2)
      IDM1=IDM(1)
      IDM2=IDM(2)
      IES=MAX0(IDM1,IDM2)
C     DO 3 I=1,IEND
C     KK=KKARAY(MKY,I)
C  3  IES=MAX0(IES,KK)
C++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C     First step ahead prediction
C++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C      WRITE(9,10)
      CALL FAPRED(XX,NXX,NRCHKX,THDXX,NTHDX,IDMX,ICM,CMA,YY,
     1IARX,IARY,ILAGX,ILAGY,MODEL)
      K1=2
      K2=1
  500 CONTINUE
C     IF(MODEL .EQ. 1) GOTO 4
C++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C     Eventual forecasting function
C++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C     CALL EFF(X,IES,NEFF,THD,NTHD,IDM,ICMATX,CMATX,
C    1IARX,IARY,ILAGX,ILAGY)
    4 CONTINUE
  111 STOP
      END
      SUBROUTINE CAND(BX,S,CTHD,IFORCE)
C===================================================================
C===================================================================
C Purpose : provide 60 choices of cutting points as threshold
C           values. (60 pts equally divided +-2 std dev. around the mean.
C Input : BX = sample mean of data;
C         S = its sample sd deviation.
C Output : CTHD contains the candidates for the threshold values.
C===================================================================
C===================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION CTHD(2,1),CHOICE(100),CHO(100),BX(1),S(1)
C.....MCKY = candidate models key (tarso or tarsc)
      DO 4 MCKY=1,2
      IF (MCKY .EQ. 1) MCKYM=1
      IF (MCKY .EQ. 2) MCKYM=2
C     MARTIN KNOTTERS, 25-11-1996: MCKYM 1 EN 2 VERWISSELD I.V.M.
C     THRESHOLDS IN DE X-VARIABELE I.P.V. DE Y-VARIABELE
      DO 1 I=1,100
   1  CTHD(MCKYM,I)=BX(MCKY)-(1.-(2.*I-1)/100.)*2.*S(MCKY)
C.....Search around the std dev.
C1    CTHD(MCKYM,I)-BX(MCKY)-(1.-(2.*I-1)/60.)*S(MCKY)
   4  CONTINUE
C
      RETURN
      END
      SUBROUTINE LINMUD(X,N)
C===================================================================
C===================================================================
C Purpose: provide the Lin-Mudholkar statistic to test the
C          assumption that the input data X are normally distributed.
C Input: X=data;
C        N=its length.
C Output: the Z-statistic.
C         In the case that the Z-statistic cannot be computed, a 
C         corresponding message is printed.
C Subroutines called: LINMY
C                     BAR,DEM,MULT
C===================================================================
C===================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION X(1),Y(1000)
      DO 1 I=1,N
      T=X(I)
      X(I)=0.0
      CALL LINMY(X,V,N)
      Y(I)=V
    1 X(I)=T
      CALL BAR(X,BX,N)
      CALL BAR(Y,BY,N)
      CALL DEM(X,BX,N)
      CALL DEM(Y,BY,N)
      CALL MULT(X,Y,N,V1)
      CALL MULT(X,X,N,V2)
      CALL MULT(Y,Y,N,V3)
C.....Restore the actual value to X
      CALL DEM(X,-BX,N)
      CALL DEM(Y,-BY,N)
C.....Restore the actual value to X
      R=SQRT(V2*V3)
      R=V1/R
      IF(R .LE. -1.0 .OR. R .GE. 1.0) GOTO 2
      Z=1./2.*LOG((1.+R)/(1.-R))
      Z=Z/SQRT(3./N)
      WRITE(9,100) Z
  100 FORMAT(//' Z-STATISTICS =',E15.6)
      RETURN
    2 CONTINUE
      WRITE(9,200) R,N
  200 FORMAT(//'  R = ',E15.6,' Z CANNOT BE COMPUTED , N = ',I5)
      RETURN
      END
      SUBROUTINE BAR(X,BX,N)
C===================================================================
C===================================================================
C Purpose: provide sample mean of data.
C Input: X = data;
C        N = number of data.
C Output: BX = sample mean.
C===================================================================
C===================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION X(1)
C      REAL*8 WORK
      DO 1 I=1,N
      T=X(I)
    1 WORK=WORK+DBLE(T)
      WORK=WORK/N
      BX=WORK
      RETURN
      END
      SUBROUTINE DEM(X,BX,N)
C===================================================================
C===================================================================
C Purpose: mean deletion.
C Input: X = data;
C        N = number of data.
C Output: X = data - sample mean.
C===================================================================
C===================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION X(1)
      DO 1 I=1,N
    1 X(I)=X(I)-BX
      RETURN
      END
      SUBROUTINE MULT(X,Y,N,V)
C===================================================================
C===================================================================
C Purpose: to obtain the inner product of X & Y.
C Input: X & Y = arrays of data;
C        N = their common length.
C Output: V = inner product of X & Y.
C===================================================================
C===================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION X(1),Y(1)
C      REAL*8 WORK1,WORK2
      WORK1=0.0
      DO 1 I=1,N
      T1=X(I)
      T2=Y(I)
      WORK2=DBLE(T1)*DBLE(T2)
    1 WORK1=WORK1+WORK2
      V=WORK1
      RETURN
      END
      SUBROUTINE LINMY(X,V,N)
C===================================================================
C===================================================================
C Purpose: V from X, where V is to be used in calculating
C          the Z-statistic:
C          V = cube root of (Nth of (sum of X squared)-
C            (N-1)th of (square of sum of X))
C Input: X = array of data;
C        N = length of X;
C        V: see discussion above.
C===================================================================
C===================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION X(1)
      CALL BAR (X,BX,N)
      CALL MULT(X,X,N,R)
      V=R-BX*BX/(N-1)*N*N
      V=V/N
      IS=1
      IF(V .LT. 0.0) IS=-1
      V=IS*V
      IF(V .EQ. 0.0) GOTO 1
      V=V**0.333333
      V=IS*V
      RETURN
    1 V=0.0
      RETURN
      END
      SUBROUTINE DIFF1(N,N0,X)
C===================================================================
C===================================================================
C     First difference of data.
C===================================================================
C===================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION X(1000)
      N0=N0-1
      N=N-1
      DO 1 I=1,N0
    1 X(I)=X(I+1)-X(I)
      WRITE(9,10) (X(I),I=1,N0)
   10 FORMAT(/' DATA (FIRST DIFFERENCED) '/
     1 (/' ',7F12.2))
      RETURN
      END
      SUBROUTINE RIDENT(X,N,THDD,NTHD,CTHD,ID1,ID2,IDM,MAIC,
     1VAV,CMATX,ICMATX,MODEL,ISEL,IARX,IARY,ILAGX,ILAGY,IFORCE,
     2ISK,MAXAR)
C===================================================================
C===================================================================
C Purpose: pinpoint the rough threshold values and the delay.
C Input: X = data;
C        N = its number;
C        NTHD+1 = number of pieces;
C        ID1,ID2  constitute the range of delays to be searched.
C Output: ** K = 1 means: regress X on past X and Y **;
C         ** K = 2 means: regress Y on past Y and X **;
C         MAIC(K) = minimum AIC among the possible TARSO/TARSC models;
C         VAV(K,I) = mean sum of squared errors for the I th piece;
C         CMATX(K,I,J) = J th coefficient of the I th AR model;
C         ICMATX(K,I) = number of parameters of the I th AR model;
C         THDD(K) = array of 'best' threshold values in this stage
C                  of model searching;
C         IDM(K) = 'best' delays corresponding to MAICE.
C Remark: CTHD is working space for storing possible sets of thres-
C         hold values.
C SUBROUTINES CALLED : COMLEX,RAIC
C===================================================================
C===================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      REAL*8 MAIC
      LOGICAL L1/.TRUE./,L2,L3
      DIMENSION IPOS(100),THDM(5),ID(2),IPOS3(100)
      DIMENSION N(2),NTHD(2),ID1(2),ID2(2),IDM(2),TAICM(2)
      DIMENSION X(2,1000),THD(2,4),THDD(2,4),MAIC(2)
      DIMENSION ICMATX(2,5),CMATX(2,5,32),VAV(2,5),CTHD(2,140)
      DIMENSION IARX(2,5),IARY(2,5),ILAGX(2,50,5),ILAGY(2,50,5)
      DIMENSION NE(2),RES(2,1000),RDN(2,1000)
      DIMENSION ANORM(5)
      IDM(1)=-1
      IDM(2)=-1
C.....The correct number of loops is determined by COMLEX.
C.....If all possible combinations are exhausted, it will
C.....break the loop automatically.
      LOOP=100000
C******LOOP=100000 i.p.v. 1000, M. Knotters, 3-4-1997*******
C.....Set an astronomically large number to MAIC
C.....in order to find the minimum for MAIC.
      MAIC(1)=1.0E+37
      MAIC(2)=1.0E+37
C.....L2 is set .TRUE. means that RAIC returns TAICM only.
      L2=.TRUE.
      IF (IFORCE .NE. 0) GOTO 101
      WRITE(9,100)
  100 FORMAT(' ROUGH IDENTIFICATION'//'BEHAVIOR OF AIC VS '
     1'DELAY , THRESHOLD'//'      AIC ','  DELAY' ,'  THRESHOLD ',
     19X,'MODEL KEY')
  101 CONTINUE
C.....MCKY = key of model choice
      DO 300 MCKY=1,MODEL
C         IF (MCKY .EQ. 2) GOTO 300
         II1=ID1(MCKY)
         II2=ID2(MCKY)
         DO 330 II=II1,II2
            ID(1)=II
            ID(2)=II
C.....L2 is set .TRUE. means that RAIC returns RAICM only.
            L2=.TRUE.
            L3=.TRUE.
            DO 2 I=1,LOOP
C.....Assign threshold values.
               NTHDX=NTHD(1)
               CALL COMLEX(IPOS,NTHDX,100,L2,*6,*1)
C               IF(IND .NE. 0) GO TO 1
C******Correction by M. Knotters, 16-4-1997******
    6          CONTINUE
               DO 3 IL=1,NTHDX
                  LL=IPOS(IL)
    3          THD(1,IL)=CTHD(1,LL)
               IF (MODEL .EQ. 1) THEN
                  NTHDX=NTHD(1)
                  ELSE
                  NTHDX=NTHD(2)
               ENDIF
               CALL COMLEX(IPOS3,NTHDX,100,L3,*7,*1)
    7          CONTINUE
               DO 8 IL=1,NTHDX
                  LL=IPOS3(IL)
    8          THD(2,IL)=CTHD(2,LL)
      CALL RAIC(X,N,THD,NTHD,ID,VAV,CMATX,ICMATX,TAICM,L1,
     *MODEL,ISEL,IARX,IARY,ILAGX,ILAGY,RES,RDN,NE,IES,ANORM,ISK,MAXAR)
               NTHDC=NTHD(MCKY)
      IF (IFORCE .NE. 0) GOTO 201
      WRITE(9,200) MCKY,TAICM(MCKY),ID(MCKY),(THD(MCKY,LK),LK=1,NTHDC)
  200 FORMAT('   ',I5,1X,E10.4,1X,I5,1X,4F10.4)
  201 CONTINUE
C.....Seek the minimum TAICM (AIC)
               IF (MAIC(MCKY) .LT. TAICM(MCKY)) GOTO 2
               MAIC(MCKY)=TAICM(MCKY)
               IDM(MCKY)=ID(MCKY)
               IF(NTHD(MCKY) .EQ. 0) GOTO 2
               DO 202 LK=1,NTHDC
                  THDD(MCKY,LK)=THD(MCKY,LK)
  202          CONTINUE
    2       CONTINUE
    1    CONTINUE
  330    CONTINUE
C      DO 203 LK=1,NTHDCC
C      WRITE(9,200) MAIC(1),IDM(1),THDD(1,LK),
C     *MAIC(MODEL),IDM(MODEL),THDD(MODEL,LK)
C  200 FORMAT('    ',E10.4,1X,I5,1X,F10.4,'   ',E10.4,1X,I5,1X,F10.4)
  203 CONTINUE
  300 CONTINUE
      RETURN
      END
      SUBROUTINE COMLEX(K,IR,N,L,*,*)
C==================================================================
C==================================================================
C Purpose: combinations of IR objects taken from 1,2,...N.
C Input: IR
C        N
C        L = logical variable: should be set .TRUE. if K is
C            to contain (1,2,...IR) when COMLEX is first called.
C Output: K = containing IR object from N numbers.
C Remarks: the first exit means that other N C IR combinated are
C          not enumerated;
C          the last EXIT takes place if all combinations have been
C          enumerated.
C===================================================================
C===================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION K(1)
      LOGICAL L
      IND=0.
      IF(.NOT.L) GOTO 1
      DO 2 I=1,IR
    2 K(I)=I
      L=.FALSE.
      RETURN 1
    1 CONTINUE
      DO 3 I=1,IR
      II=IR+1-I
      IF(K(II) .GE. N-IR+II) GOTO 3
      K(II)=K(II)+1
      IS=II+1
      IF(IS .GT. IR) RETURN1
      DO 4 J=IS,IR
    4 K(J)=K(J-1)+1
      RETURN 1
    3 CONTINUE
      RETURN 2
      END
      SUBROUTINE SORT(X,N,AX,IAX1,IAX2,THD,NTHD,ID,NOBS,IER,IES,
     *YY,IIARX,IIARY,IILAGX,IILAGY,ISK,MAXAR)
C===================================================================
C===================================================================
C Purpose: sort the data for which an appropriate AR-model applies.
C Input: X = data;
C        N = its dimension;
C        AX = array containing the sorted data;
C        THD    = containing the threshold value;
C        NTHD+1 = number of pieces;
C        ID     = delay parameter.
C Output: error code = 0 : O.K.
C                      1 : some pieces do not have enough data to
C                          estimate the corresponding AR-model.
C         IES = the starting position for the sorting;
C         NOBS(I) = the number of data falling in the Ith piece.
C===================================================================
C===================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION NOBS(1),YY(1),THD(1),X(1)
      DIMENSION IIARX(5),IIARY(5),IILAGX(50,5),IILAGY(50,5)
      DIMENSION AX(IAX1,IAX2,1)
      JEND=NTHD+1
C.....Clear NOBS.
      DO 1 I=1,JEND
    1 NOBS(I)=0
      IES=ID
C.....Choose appropriate starting position.
      DO 2 J=1,JEND
         IF (IIARX(J) .EQ. 0) THEN 
            KK = 0
            ELSE
            KK=IILAGX(IIARX(J),J)
         ENDIF
C*****Correction by M. Knotters, 10 April 1997*****
c !!!     KK=IILAGX(IIARX(J),J)
C**************************************************
    2 IESX=MAX0(IESX,KK)
      DO 21 J=1,JEND
         IF (IIARY(J) .EQ. 0) THEN 
            KK = 0
            ELSE
            KK=IILAGY(IIARY(J),J)
         ENDIF
   21 IESY=MAX0(IESY,KK)
C*****Correction by M. Knotters, 1 April 1997*****
      IES2=MAX0(IESX,IESY)
      IES3=MAX0(ISK,IES2)
      IES=MAX0(IES,IES3)
      IES=IES+1
C*************************************************
C.....Sort X's into AX's.
      DO 3 I=IES,N
         ICP=1
C.....Assign to first piece for NTHD = 0.
         IF(NTHD .EQ. 0) GOTO 5
C.....First assign to last piece.
         ICP=NTHD+1
         II=I-ID
C.....See to which piece X(I) belongs. Note that it is determined by
C.....X(I-DELAY).
         DO 4 K=1,NTHD
            IF(X(II) .GT. THD(K)) GOTO 4
            ICP=K
C.....Ah, it is found.
            GOTO 5
    4    CONTINUE
    5    CONTINUE
C.....Indicate the current position X(I) occupies in the ICP piece.
         NOBS(ICP)=NOBS(ICP)+1
         NOB=NOBS(ICP)
C.....Assign the first column of AX(NOB,I,ICP).
         AX(NOB,1,ICP)=1.0
C.....Assign the X-part of AX(NOB,I,ICP).
         KENDX=IIARX(ICP)+1
         DO 6 K=2,KENDX
            K3=K-1
            K22=IILAGX(K3,ICP)
            AX(NOB,K,ICP)=X(I-K22)
    6    CONTINUE
C.....Assign the Y-part of AX(NOB,I,ICP).
         KSTART=KENDX+1
         KENDY=KENDX+IIARY(ICP)
         DO 61 K=KSTART,KENDY
            K3=K-KENDX
            K22=IILAGY(K3,ICP)
            AX(NOB,K,ICP)=YY(I-K22)
   61    CONTINUE
C.....Assign the last column of AX(NOB,I,ICP).
         KEND=KENDY+1
         AX(NOB,KEND,ICP)=X(I)
    3 CONTINUE
C.....Check if enough data to estimate the AR-model in each of the regions.
C.....Check if the regime contains enough data to apply Akaike's 
C     Information Criterion
C******Modification by M. Knotters
      IER=0
      DO 7 J=1,JEND
          NN=NOBS(J)
c         RNN1=2*SQRT(REAL(NN))
c         RNN2=(REAL(NN))/2
c         IHX = IIARX(J)
c         IHY = IIARY(J)
C         The minimum number of observations in a regime can be based on
C         the number of free parameters of the actual candidate model 
C         (AR-parameters + constant + residual variance) or at the number
C         of free parameters of the largest candidate model:
C         KK=IHX+IHY+2
c          KK=2*MAXAR+2
c         RKK=REAL(KK)
C        The minimum number of observations in a regime can be fixed at 
C        for instance 20.
         IF(NN .GE. 20) GOTO 7
c         IF(RNN1 .GT. RKK .AND. RNN2 .GT. RKK) GOTO 7
         IER=1
C.....The Jth regime lacks data, so return with IER=1.
         RETURN
    7 CONTINUE
C.....Check if variables in a regime have variance greater than zero,
C     in order to perform least squares estimation via Housholder
C     transformation successfully.
C     Modification by M. Knotters, 17 April 1997.
      IER=0
      DO 72 J=1,JEND
         NN=NOBS(J)
         KEND=IIARX(J)+IIARY(J)+2
         DO 73 JJJ=2,KEND
            RMIN=AX(1,JJJ,J)
            RMAX=AX(1,JJJ,J)
            DO 71 JJ=1,NN
               IF (AX(JJ,JJJ,J).LT.RMIN) RMIN=AX(JJ,JJJ,J)
               IF (AX(JJ,JJJ,J).GT.RMAX) RMAX=AX(JJ,JJJ,J)
   71       CONTINUE
            IF (RMIN .NE. RMAX) GOTO 73
C.....A variable in the Jth regime has zero variance. Therefore,
C     the program returns with IER=1.
            IER=1
            RETURN
   73    CONTINUE
   72 CONTINUE
      RETURN
      END
      SUBROUTINE HUSHLD(AH1,N,K,IA11)
C===================================================================
C===================================================================
C Purpose: HOUSHOLDER TRANSFORMATION
C Input : AH1 = array to be transformed;
C         N = number of columns;
C         K = number of rows;
C         IA11 = number of columns of AH1 in the calling program.
C Output: AH1 = transformed array.
C==================================================================
C==================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION AH1(IA11,1),Z(1000)
      TOL=1.0E-30
      NK=MIN0(N,K)
      DO 100 II=1,NK
      H=0.0
      DO 10 I=II,N
      Z(I) = AH1(I,II)
   10 H=H+Z(I)*Z(I)
      IF(H .GT. TOL) GOTO 40
      G=0.0
      GOTO 100
   40 G=SQRT(H)
      F=AH1(II,II)
      IF(F .GE. 0.0) G=-G
      Z(II)=F-G
      H=H-F*G
      IF(II .EQ. K) GOTO 100
      II1=II+1
      DO 90 J=II1,NK
      S=0.0
      DO 20 I=II,N
   20 S=S+Z(I)*AH1(I,J)
      S=S/H
      DO 30 I=II,N
   30 AH1(I,J)=AH1(I,J)-Z(I)*S
   90 CONTINUE
  100 AH1(II,II)=G
      RETURN
      END
      SUBROUTINE ARMFIT(AH1,IA11,AC1,K,N,VA,IMIN,AICM,ISEL)
C==================================================================
C==================================================================
C Purpose: given the lags for different pieces, compute the AIC
C          for the AR-model in the Ith piece.
C Input: AH1 = housholder transformed array (so it is upper triangular);
C        IA11 = number of rows of AH1 in the calling program;
C        K = number of columns;
C        N = number of rows (number of data);
C        ISEL = indicator for information criterion.
C Output: AR(IMIN-1) = the chosen AR-model;
C         IMIN = the number parameters of the AR-model;
C         AICM = its corresponding information criterion;
C         VA = mean sum of squared errors;
C         AC1 = contains the coefficients of the AR-model.
C Here, AC2 and AC3 are working vectors.
C===================================================================
C===================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
C      REAL*8 SUM
      DIMENSION AH1(IA11,1)
      DIMENSION AC1(50),AC2(50),AC3(50)
C.....DIMENSION AC1(NK),AC2(NK),AC3(NK)
      K1=K+1
      K1=MIN0(N,K1)
      OSD=0.0E00
      FN=N
      IF (ISEL .NE. 1) GOTO 11
C.....Aikaike Information Criterion
      DO 10 I=1,K1
         M=K1-I+1
C.....MP is the number of autoregressive terms:
         MP=M-2
         OSD=OSD+AH1(M,K1)*AH1(M,K1)
         AC2(M)=OSD/FN
   10 AC3(M)=FN*LOG(AC2(M))+2*(MP+1)
c   10 AC3(M)=FN*LOG(AC2(M))+2*(MP)
      GOTO 15
   11 IF (ISEL .NE. 2) GOTO 13
C.....Corrected Akaike Information Criterion
      DO 12 I=1,K1
         M=K1-I+1
         MP=M-2
         OSD=OSD+AH1(M,K1)*AH1(M,K1)
         AC2(M)=OSD/FN
         MH=MP-3
         IF (FN .EQ. MH) THEN
            AC3(M)=1.0E+37
         ELSE
      AC3(M)=FN*LOG(AC2(M))+(FN*(FN+MP+1))/(FN-MP-3)
c      AC3(M)=FN*LOG(AC2(M))+(FN*(FN+MP))/(FN-MP-2)
         ENDIF
   12 CONTINUE
      GOTO 15
C.....Bayes Information Criterion
   13 DO 14 I=1,K1
         M=K1-I+1
         MP=M-2
         OSD=OSD+AH1(M,K1)*AH1(M,K1)
         AC2(M)=OSD/FN
   14 AC3(M)=FN*LOG(AC2(M))+(MP+1)*LOG(FN)
c   14 AC3(M)=FN*LOG(AC2(M))+(MP)*LOG(FN)
   15 CONTINUE  
C      IMIN=0
C      AICM= 1.E+37
C      DO 20 I=2,K1
C         IF (AC3(I) .GE. AICM) GOTO 20
C         IMIN=I-1
C         AICM=AC3(I)
C   20 CONTINUE
      IMIN=K1-1
      AICM=AC3(K1)
      IF(IMIN .EQ. 1) GOTO 200
      DO 100 M=IMIN,IMIN
         AC1(M)=AH1(M,K1)/AH1(M,M)
         MM1=M-1
         DO 110 II=1,MM1
            I=M-II
            SUM=DBLE(AH1(I,K1))
            I1=I+1
            DO 120 J=I1,M
  120       SUM=SUM-DBLE(AC1(J))*DBLE(AH1(I,J))
  110    AC1(I)=SUM/AH1(I,I)
  100 CONTINUE
      VA=AC2(IMIN+1)
      RETURN
  200 VA=AC2(2)
      AC1(1)=AH1(1,K1)/AH1(1,1)
      RETURN
      END
      SUBROUTINE RAIC(X,N,THD,NTHD,ID,VAV,CMATX,ICMATX,TAICM,L,
     *MODEL,ISEL,IARX,IARY,ILAGX,ILAGY,RES,RDN,NOBST,IES,
     *ANORM,ISK,MAXAR)
C===================================================================
C===================================================================
C Purpose: after sorting and Housholder transformation, the
C          AIC of the particular TARSO/TARSC model is returned.
C RAIC has also the ability of printing the relevant information of
C the TARSO/TARSC model and provides diagnostics on the fitted residuals
C if L is set .FALSE. .
C Input : X = data;
C         N =its length;
C         THD = array of threshold values;
C         NTHD+1 = the number of pieces;
C         ID = delay;
C         L : Boolean variable: if .TRUE. only AIC is returned;
C                               if .FALSE. see above;
C         ISEL = indicator for information criterion: Akaike Information
C                Criterion (1), a corrected AIC (2) or Bayes Information
C                Criterion (3);
C Output : VAV(K<I) = mean sum of squared errors for Ith piece;
C          CMATX(K,I,J) = Jth coefficient for Ith AR model;
C          ICMATX = number of parameters for the Ith AR model;
C          ** K = 1 means: regress X on X and Y **
C          ** K = 2 means: regress Y on Y and X **
C          TAICM = information criterion for the TARSO/TARSC model.
C===================================================================
C===================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION THD(2,4),VAV(2,5),N(2),NTHD(2),ID(2)
      DIMENSION CMATX(2,5,1),ICMATX(2,5),X(2,1000),YY(1000)
     *,THDXX(4)
      DIMENSION AX(500,50,5),SAX(500,50),AC1(50),NOBS(5),ICM(5)
      DIMENSION TAICM(2),XX(1000),NOBST(2),CMA(5,50)
      DIMENSION IARX(2,5),IARY(2,5),ILAGX(2,50,5),ILAGY(2,50,5)
      DIMENSION IIARX(5),IIARY(5),IILAGX(50,5),IILAGY(50,5)
      DIMENSION RES(2,1000),RDN(2,1000),SIMV(1000),DENORM(1000)
      DIMENSION SAXT(50,500),SAXC(50,50),XY(500),PAR(50,50),SAY(500)
      DIMENSION SA(500),RESVAR(50),GS(50),AIC(50),AC2(50)
      DIMENSION A(50),VAR(50),PARR(50,50),SXR(50,50),SU(50,50)
      DIMENSION SX(50,50),SXX(50,50),SN(500,50),TT(50),IB(50)
      DIMENSION ANORM(5)
C     DOUBLE PRECISION AICM,YM,WT
C
      INTEGER LL1,UU,K2,K1,J1,IA(50,5),MFIT,NOBSTT
      INTEGER K3,KK
      REAL IC(30)
C
C     DATA PAI2/6.2831853D0/
C
      LOGICAL L
      DATA IAX1,IAX2,IAX3/500,50,2/
C.....Sort the data for estimating the TARSO/TARSC model.
      J1=1
      J2=2
      DO 333 L1=1,MODEL
         IDXX=ID(L1)
         NXX=N(L1)
         NTHDXX=NTHD(L1)
         DO 332 L2=1,5
            IIARX(L2)=IARX(L1,L2)
            IIARY(L2)=IARY(L1,L2)
            DO 327 ITEL=1,IIARX(L2)
               IILAGX(ITEL,L2)=ILAGX(L1,ITEL,L2)
  327       CONTINUE
            DO 328 ITEL=1,IIARY(L2)
               IILAGY(ITEL,L2)=ILAGY(L1,ITEL,L2)
  328       CONTINUE
  332    CONTINUE
         DO 331 L2=1,4
  331    THDXX(L2)=THD(L1,L2)
         NJ2=N(J2)
         NJ1=N(J1)
         DO 330 L2=1,NJ1
  330    XX(L2)=X(J1,L2)
         DO 329 L2=1,NJ2
  329    YY(L2)=X(J2,L2)
      CALL SORT(XX,NXX,AX,IAX1,IAX2,THDXX,NTHDXX,IDXX,NOBS,IER,
     *IES,YY,IIARX,IIARY,IILAGX,IILAGY,ISK,MAXAR)
C.....If (IER.EQ.1) then some piece lacks data with which to estimate
C.....the model, so TAICM is set very large and control is given back
C.....to the calling program.
         IF(IER.NE.1) GOTO 1
         TAICM(L1)=1.0E+37
         IF(.NOT.L) WRITE(9,15)
   15    FORMAT(' SOME PIECES LACK DATA FOR ESTIMATION ')
         GO TO 1691
C.....TAICM, finally, is the AIC for the particular model.
C.....Initially, it is set to 0.0 .
    1    TAICM(L1)=0.0
C.....NOBST = total number of data for estimating the TARSO/TARSC model.
         NOBST(L1)=0.0
         IEND=NTHD(L1)+1
         IF (.NOT.L) THEN
         WRITE(9,17)
   17 FORMAT(/' ****************************************************'
     1/' Results of model estimation'
     2/' ****************************************************')
         ENDIF
         DO 2 I=1,IEND
            KK=IARX(L1,I)+IARY(L1,I)
            K1=KK+2
            K2=KK+1
            NOB=NOBS(I)
            NOBST(L1)=NOBST(L1)+NOB
C.....SAX contains the augmented 'design' matrix of the Ith piece.
C.....K1 is the number of columns in SAX, NOB is the number of rows.
            DO 3 I1=1,NOB
            DO 3 I2=1,K1
    3       SAX(I1,I2)=AX(I1,I2,I)
      CALL HUSHLD(SAX,NOB,K1,IAX1)
      CALL ARMFIT(SAX,IAX1,AC1,K2,NOB,VA,IMIN,AICM,ISEL)
            TAICM(L1)=TAICM(L1)+AICM
            IF(L) GOTO 2
C.....Recording and printing of parameters and information.
            VAV(L1,I)=VA
            ICMATX(L1,I)=IMIN
            DO 4 I3=1,IMIN
    4       CMATX(L1,I,I3)=AC1(I3)
            VA1=SQRT(VA)
C******Output format modified, M. Knotters, 22-4-1997.******
      WRITE(9,47)IARX(L1,I),IARY(L1,I)
   47 FORMAT(/' No of Y parameters = ',I2,' ; No of X parameters = ',I2)
      IF (IARX(L1,I) .GT. 0) THEN
         WRITE(9,48)(ILAGX(1,ILX,I),ILX=1,IARX(L1,I))
   48    FORMAT(' Lags for Y-terms :',20I2)
      ENDIF
      IF (IARY(L1,I) .GT. 0) THEN
         WRITE(9,49)(ILAGY(L1,ILY,I),ILY=1,IARY(L1,I))
   49    FORMAT(' Lags for X-terms :',20I2)
      ENDIF
      WRITE(9,50)I,NOB,IMIN,VA1,(AC1(KL),KL=1,IMIN)
   50 FORMAT(/' Piece ',I5,/' No of data = ',I5,/
     1' No of parameters :',I5,1X,/
     2' Residual standard deviation =',F10.4,/
     3' Coefficients :'/(' ',7F10.4))
      CALL VARCOV(SAX,IAX1,IMIN,VA)
      WRITE(9,16)
   16 FORMAT(' ****************************************************')
    2    CONTINUE
C.....EFSS = effective sample size
         EFSS=NOBST(L1)
C
         IF (ISEL .NE. 1) GOTO 805
C.....Akaike Information Criterion
         TAICM(L1)=(TAICM(L1)+2*NTHDXX)/EFSS
         IF (L) GO TO 1691
      WRITE(9,100)NOBST(L1),TAICM(L1),ID(L1),NTHD(L1)
  100 FORMAT(' Effective no of observations = ',I5/' Normalized AIC = ',
     1F10.4/' Delay = ',I5,/' No of thresholds = ',I5)
         GOTO 815
C
  805    IF (ISEL .NE. 2) GOTO 810
C.....Corrected Akaike Information Criterion
      TAICM(L1)=(TAICM(L1)+(EFSS*(EFSS+NTHDXX))/(EFSS-NTHDXX-2))/EFSS
         IF (L) GO TO 1691
      WRITE(9,101)NOBST(L1),TAICM(L1),ID(L1),NTHD(L1)
  101 FORMAT(' Effective no of observations = ',I5/
     1' Normalized AICc = ',
     2F10.4/' Delay = ',I5/' No of thresholds = ',I5)
         GOTO 815
C
C.....Bayes Information Criterion
c  810    TAICM(L1)=(TAICM(L1)+LOG(EFSS)*NTHDXX)/EFSS (false definition!)
C        When using BIC the number of thresholds must be known!!!
  810    TAICM(L1)=TAICM(L1)
         IF (L) GO TO 1691
      WRITE(9,102)NOBST(L1),TAICM(L1),ID(L1),NTHD(L1)
  102 FORMAT(' Effective no of observations = ',I5/' Normalized BIC = ',
     1F10.4/' Delay = ',I5/' No. of thresholds = ',I5)
C
  815    CONTINUE
      WRITE(9,200)(THD(L1,I),I=1,NTHDXX)
  200 FORMAT(/' Threshold values :  '/(' ',10F10.4))
         DO 230 L2=1,5
  230    ICM(L2)=ICMATX(L1,L2)
         DO 240 L7=1,5
         DO 240 L8=1,32
  240    CMA(L7,L8)=CMATX(L1,L7,L8)
C.....Normalized fitted residuals.
    7 CALL NFR(XX,NXX,IES,THDXX,NTHDXX,IDXX,ICM,CMA,
     1NOBS,YY,IIARX,IIARY,IILAGX,IILAGY,SIMV,DENORM,ANORM)
      DO 241 IT=1,NOBST(L1)
         RES(L1,IT)=SIMV(IT)
         RDN(L1,IT)=DENORM(IT)
  241 CONTINUE
 1691    J1=2
         J2=1
  333 CONTINUE
      RETURN
      END
      SUBROUTINE NFR(STV,N,IS,THD,NTHD,ID,ICMATX,CMATX,NOBS,STVYY,
     *IIARX,IIARY,IILAGX,IILAGY,SIMV,DENORM,ANORM)
C===================================================================
C===================================================================
C Purpose: to calculate the normalized fitted residuals
C          and detailed diagnostics.
C Input: STV = array of data;
C        N = its length;
C        IS = starting position from which fitted residuals are
C             calculated;
C        THD = array of threshold values;
C        NTHD+1 = number of pieces;
C        ID = delay;
C        ICMATX(I) = number of parameters in the Ith piece;
C        CMATX(I,J) = Jth coefficient of the Ith AR-model;
C        VV(I) = the sample sum of squared errors for the Ith ar model;
C        NOBS(I) = number of data falling in the Ith piece;
C Output: SIMV(IS+1)-SIMV(N) contains the normalized residuals.
C SUBROUTINES CALLED DESACF,HIST,LINMLD,NORPLT
C===================================================================
C===================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
C      REAL*8 T,TT
      DIMENSION ANORM(5)
C.....REAL*8 T,ANORM(NR)
      DIMENSION STV(1),SIMV(1000),THD(1),ICMATX(1),CMATX(5,1),STVYY(1),
     *P(100),DENORM(1000)
      DIMENSION NOBS(1)
      DIMENSION IIARX(5),IIARY(5),IILAGX(50,5),IILAGY(50,5)
      INTEGER INDEX(1000)
C.....INTEGER*2 INDEX(ND)
      DIMENSION PX(1000)
      DIMENSION TRT(100)
      COMMON /MAXMIN/AMAX,AMIN
      DO 878 I=1,5
  878 ANORM(I)=0.0
      WRITE(9,100)
  100 FORMAT(//' ORIGINAL DATA',5x,'FITTED DATA',5x,'RESIDUALS')
      DO 2 I=IS,N
C.....Sorting.
      IP=1
      IF(NTHD .EQ. 0) GOTO 3
      ITEST=I-ID
      DO 4 J=1,NTHD
      IF(STV(ITEST) .GT. THD(J)) GOTO 4
      IP=J
      GOTO 3
    4 CONTINUE
      IP=NTHD+1
    3 CONTINUE
C.....Remember which piece by recording in 'INDEX'
      INDEX(I)=IP
C.....Calculation of fitted residuals:
      NPARM=IIARX(IP)+IIARY(IP)+1
      T=DBLE(CMATX(IP,1))
      IF(NPARM .LT. 2) GOTO 8
C.....Create vectors P:
      DO 10 JX=1,IIARX(IP)
         IM=IILAGX(JX,IP)
         P(JX+1)=STV(I-IM)
   10 CONTINUE
      DO 11 JY=1,IIARY(IP)
         JJS=JY+IIARX(IP)+1
         IM=IILAGY(JY,IP)
         P(JJS)=STVYY(I-IM)
   11 CONTINUE
C.....Calculate fitted values:
      DO 5 K=2,NPARM
    5 T=DBLE(CMATX(IP,K))*DBLE(P(K))+T
    8 SIMV(I)=DBLE(STV(I))-T
C.....Writing original data, fitted data and residuals.
      WRITE(9,101)STV(I),T,SIMV(I)
  101 FORMAT(f12.2,6x,f10.4,6x,f10.4)
C.....Calculation of sum of square of residuals piece by piece.
C.....ANORM(I) finally stores the residual sum of squares in the Ith piece.
      ANORM(IP)=DBLE(SIMV(I))*DBLE(SIMV(I))+ANORM(IP)
    2 CONTINUE
      IEND=NTHD+1
      DO 17 I=1,IEND
      FNOB=NOBS(I)
      ANORM(I)=ANORM(I)/DBLE(FNOB)
   17 ANORM(I)=SQRT(ANORM(I))
C.....ANORM(I) stores root mean square of residuals in the Ith piece.
      DO 27 I=IS,N
      IP=INDEX(I)
      II=I-IS+1
C.....Normalize the fitted residuals. These are returned to the
C.....main program via subroutine RAIC, in order to use them in
C.....estimating the uncertainty of the threshold values for a
C.....given model by a bootstrap pocedure. Store the root mean square
C.....used for normalization in the vector DENORM. DENORM is used later
C.....on to denormalize resampled residuals.
      SIMV(II)=DBLE(SIMV(I))/ANORM(IP)
      DENORM(II)=ANORM(IP)
   27 CONTINUE
      RETURN
      END
      SUBROUTINE TRANS(X,Y,N0,ITRANS,N)
C===================================================================
C===================================================================
C Purpose: to transform data.
C Input: X = array of data;
C        N = length of data;
C        ITRANS : 1 = no transformation;
C                 2 = square root;
C                 3 = log to the base 10;
C                 4 = log to the base e;
C                 5 = EXP(X);
C                 6 = SQUARE;
C                 7 = 2*(SQRT(XT+1)-1.);
C                 8 = first difference;
C                 9 = difference of LOG;
C                10 = 1000*(LOG10*X-7)
C                11 = 1000*(LOG10*X)
C Output: Y = transformed X
C===================================================================
C===================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION X(2,1),Y(2,1),N(1),ITRANS(1),N0(1),YY(1000)
      DO 80 K=1,2
      ITC=ITRANS(K)
      NC=N0(K)
      GOTO (1,2,3,4,5,6,7,8,9,10,11,12,13) ,ITC
    1 GO TO 80
    2 DO 21 I=1,NC
   21 Y(K,I)=SQRT(X(K,I))
      GO TO 80
    3 DO 31 I=1,NC
   31 Y(K,I)=LOG10(X(K,I))
      GO TO 80
    4 DO 41 I=1,NC
   41 Y(K,I)=LOG(X(K,I))
      GO TO 80
    5 DO 51 I=1,NC
   51 Y(K,I)=EXP(X(K,I))
      GO TO 80
    6 DO 61 I=1,NC
      T=X(K,I)
   61 Y(K,I)=T*T
      GO TO 80
    7 DO 71 I=1,NC
   71 Y(K,I)=2.*(SQRT(X(K,I)+1.)-1.)
    8 GO TO 80
    9 DO 91 I=1,NC
   91 Y(K,I)=LOG(X(K,I))
      DO 92 I=1,NC
   92 YY(I)=Y(K,I)
      NKK=N(K)
      N0KK=N0(K)
      CALL DIFF1(NKK,N0KK,YY)
      N(K)=NKK
      N0(K)=N0KK
      DO 93 I=1,N0KK
   93 Y(K,I)=YY(I)
      GO TO 80
   10 DO 103 I=1,NC
  103 Y(K,I)=1000.*(LOG10(X(K,I))-7.)
      GO TO 80
   11 DO 113 I=1,NC
  113 Y(K,I)=1000.*LOG10(X(K,I))
      GO TO 80
   12 DO 882 I=1,NC
  882 Y(K,I)=Y(K,I)+.057
      GO TO 80
   13 DO 883 I=1,NC
  883 Y(K,I)=Y(K,I)-5.35
      GO TO 80
   80 CONTINUE
      RETURN
      END
      SUBROUTINE FAPRED(STV,NSTV,NSIMV,THD,NTHD,ID,ICMATX,
     1CMATX,STVYY,IARX,IARY,ILAGX,ILAGY,MODEL)
C===================================================================
C===================================================================
C PURPOSE: TO GENERATE A TABLE CONTAINING DATA, ONE STEP AHEAD
C          PREDICTION AND ABSOLUTE ERROR: ABSOLUTE ERROR=
C          DATA PREDICTION
C          ALSO ROOT MEAN SQUARE OF ERRORS, RMS , IS GIVEN
C INPUT: STV=ARRAY OF DATA
C        NSTV+1=THE STARTING POSITION WHERE PREDICTION IS CALCULATED
C        NSIMV=NUMBER OF PREDICTIONS
C        THD=ARRAY OF THRESHOLD VALUES
C        NTHD=NUMBER OF THRESHOLD VALUES
C        ID=DELAY
C        ICMATX(I)=NUMBER OF PARAMETERS IN THE ITH AR-MODEL
C        CMATX(I,J)=JTH COEFFICIENT OF THE ITH AR-MODEL
C OUTPUT: SIMV(NSTV+1)-SIMV(NSTV+NSIMV) CONTAINS THE FIRST STEP
C         AHEAD PREDICITION
C===================================================================
C===================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
C      REAL*8 T,ERROR,SSE,SSEM
      DIMENSION STV(1),SIMV(1000),THD(1),ICMATX(1),CMATX(5,1),
     *STVYY(1),P(50)
      DIMENSION IARX(2,5),IARY(2,5),ILAGX(2,50,5),ILAGY(2,50,5)
      IF(NSIMV .EQ. 0) RETURN
      WRITE(9,100)
  100 FORMAT('1 ONE STEP AHEAD PREDICTION '//
     1' COMPARISON WITH ORIGINAL DATA '/
     2'  ORIGINAL DATA  ','ONE AHEAD PRED.','   ABS. ERROR'/)
      SSE=0.0
      IS=NSTV+1
      IE=NSTV+NSIMV
      DO 1 JJJ=1,MODEL
      DO 2 I=IS,IE
C.....Sorting:
      IP=1
      IF(NTHD .EQ. 0) GOTO 3
      ITEST=I-ID
      DO 4 J=1,NTHD
      IF(STV(ITEST) .GT. THD(J)) GOTO 4
      IP=J
      GOTO 3
    4 CONTINUE
      IP=NTHD+1
    3 CONTINUE
C.....The location process is finished.
C.....Calculation of one step ahead predictions:
      NPARM=IARX(JJJ,IP)+IARY(JJJ,IP)+1
      T=DBLE(CMATX(IP,1))
      IF(NPARM .LT. 2) GOTO 555
C.....Create vectors P of predictand values:
      DO 10 JX=1,IARX(JJJ,IP)
         IM=ILAGX(JJJ,JX,IP)
         P(JX+1)=STV(I-IM)
   10 CONTINUE
      DO 11 JY=1,IARY(JJJ,IP)
         JJS=JY+IARX(JJJ,IP)+1
         IM=ILAGY(JJJ,JY,IP)
         P(JJS)=STVYY(I-IM)
   11 CONTINUE
      DO 5 K=2,NPARM
    5 T=DBLE(CMATX(IP,K))*DBLE(P(K))+T
C.....Calculate the error in the prediction
  555 ERROR=DBLE(STV(I))-T
      SSE=SSE+ERROR*ERROR
      SIMV(I)=T
      WRITE(9,200) STV(I),T,ERROR
  200 FORMAT(' ',F15.5,1X,F15.5,1X,F15.5)
    2 CONTINUE
    1 CONTINUE
C     CALCULATION OF ROOT MEAN SQUARE
      SSE=SSE/NSIMV
      SSE=SQRT(SSE)
      WRITE(9,300) SSE
  300 FORMAT(//' RMS= ',F15.5)
      RETURN
      END
      SUBROUTINE VARCOV(SAX,IAX,IMIN,VA)
C===================================================================
C===================================================================
C PURPOSE: TO PROVIDE THE VARIANCE COVARIANCE MATRIX FOR THE
C          ESTIMATES.
C INPUT: SAX=UPPER TRIANGULAR FORM OF THE DESIGN MATRIX
C        IAX=NO. OF COLUMNS OF SAX IN THE CALLING PROGRAM
C        IMIN: SAX IS OF DIMENSION IMIN BY IMIN
C        VA=SUM OF SQUARED ERRORS
C ACTION: THE SD ESTIMATES AND THE VARIANCE COVARIANCE MATRIX IS PRINTED
C SUBROUTINES CALLED: SINV
C===================================================================
C===================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION SAX(IAX,45),SDM(60)
C     DIMENSION SAX(IAX,1),SDM(NK)
      DIMENSION TA(1170)
C     DIMENSION TA(NK*(NK+1)/2)
      IC=0
C     TO COMPRESS THE UPPER TRIANGULAR MATRIX SAX INTO ONE
C     DIMENSIONAL VECTOR TA
      DO 2 I2=1,IMIN
      DO 2 I1=1,I2
      IC=IC+1
    2 TA(IC)=SAX(I1,I2)
C     CALCULATE VA*INVERSE OF THE PRODUCT OF SAX TRANSPOSE AND SAX
      CALL SINV(TA,IMIN,VA)
C     RETIREVE THE DIAGONAL AND TAKE THE SQUARE ROOT; THEY ARE
C     ESTIMATES OF STANDARD ERROR
      I=1
      IP=1
   11 SDM(I)=SQRT(TA(IP))
      I=I+1
      IP=I+IP
      IF(I .GT. IMIN) GOTO 10
      GOTO 11
   10 WRITE(9,200) (SDM(I5),I5=1,IMIN)
  200 FORMAT(//' STANDARD ERROR FOR THE ESTIMATES : '/(' ',7F10.4))
C     ARRANGE AND THEN PRINT THE VARIANCE-COVARIANCE MATRIX
      L=0
      IE=1
      IS=1
      WRITE(9,50)
    1 CONTINUE
      WRITE(9,100) (TA(J),J=IS,IE)
      L=L+1
      IS=IE+1
      IE=IS+L
      IF(IE .LE. IC) GOTO 1
   50 FORMAT(///' VARIANCE-COVARIANCE MATRIX :')
  100 FORMAT(' ',8( ' ',E10.4))
C******Correction by M. Knotters, 21-4-1997****
c 100 FORMAT(' ',10( ' ',F8.4))
      RETURN
      END
      SUBROUTINE SINV(A,N,VA)
C===================================================================
C===================================================================
C PURPOSE: TO PROVIDE THE PRODUCT OF THE INVERSE A'*A AND VA
C INPUT: A THE UPPER TRIANGULAR MATRIX STACKED UP ROW-WISE
C        N=DIMENSION OF THE TRIANGULAR MATRIX,SO N*(N-1)=LENGTH OF A
C        VA=MEAN SUM OF SQUARE ERROR
C OUTPUT: A=THE DESIRED PRODUCT AS DESCRIBED IN THE PURPOSE
C===================================================================
C===================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION A(1)
      IPIV=N*(N+1)/2
      IND=IPIV
      DO 6 I=1,N
      DIN=1.D0/DBLE(A(IPIV))
      A(IPIV)=DIN
      MIN=N
      KEND=I-1
      LANF=N-KEND
      IF(KEND) 5,5,2
    2 J=IND
      DO 4 K=1,KEND
      WORK=0.D0
      MIN=MIN-1
      LHOR=IPIV
      LVER=J
      DO 3 L=LANF,MIN
      LVER=LVER+1
      LHOR=LHOR+L
    3 WORK=WORK+DBLE(A(LVER)*A(LHOR))
      A(J)=-WORK*DIN
    4 J=J-MIN
    5 IPIV=IPIV-MIN
    6 IND=IND-1
      DO 8 I=1,N
      IPIV=IPIV+I
      J=IPIV
      DO 8 K=I,N
      WORK=0.D0
      LHOR=J
      DO 7 L=K,N
      LVER=LHOR+K-I
      WORK=WORK+DBLE(A(LHOR)*A(LVER))
    7 LHOR=LHOR+L
      A(J)=WORK*DBLE(VA)
    8 J=J+K
      RETURN
      END
      SUBROUTINE DESACF(N,DATA,VALUE,AMEAN,STD,MSPEC)
C==================================================================
C==================================================================
C THIS SUBROUTINE GIVES THE MEAN, VARIANCE(DIVIDE BY N),
C STANDARD DEVIATION, MAXIMUM, MINIMUM, AND RANGE OF THE DATA.
C AUTOCOVARIANCE FUNCTION AND AUTOCORRELATION FUNCTION ARE ALSO
C CALCULATED. CORRELOGRAM IS PLOTTED WITH CONFIDENCE LIMITS, AND
C THE NUMBER OF LAGS= NUMBER OF DATA/4.
C VARIABLE NAMES:
C N: NUMBER OF DATA
C DATA: INPUT DATA
C VALUE: IS BETWEEN 0 AND 1. IT DETERMINES THE CONFIDENCE LIMITS
C        IN THE CORRELOGRAM
C OUTPUT:
C   MSPEC=-1 MEANS SPECTRUM NOT CALCULATED
C          0 MEANS CUTTING POINT OF C(K) USED IN SPECTRUM
C          CALCUALTION IS DETERMINED BY AUTOMATED METHOD
C
C          THE METHOD:
C          THE LEAST NUMBER AFTER WHICH 5 CONSECUTIVE A.C.F. ARE
C          LESSER THAN A SMALL NUMBER IN ASOLUTE MAGNITUDE(.02)
C          THIS LEAST NUMBER  IS THEN ASSIGNED TO M
C     ANY+INTEGER: THIS IS USED DIRECTLY AS OUR LAST A.C.V. IN
C                  CALCULATING THE SPECTRUM
C===================================================================
C===================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
C      IMPLICIT REAL*8(A-H,O-Z)
C      REAL VALUE,AMEAN,STD
      DIMENSION DATA(1),SPDIF(300),ACOVF(300),ACORF(300)
      INTEGER P,CRVAL,PACF,C
C      REAL*8 T,SQUAD,SCUBE,SUM,SS,SSQ,A,AA,DMEAN,B1,BB,AKURT
      DIMENSION STAR(100),PLOT(121)
C      DATA ONE/'I'/,B/' '/,S/'*'/
C      DATA PLOT/60*' ','+',60*' '/
C     DATA STAR/100*'*'/,ONE/'I'/,B/' '/,S/'*'/,PLOT/60*' ','+',60*' '/
C     DE C VOOR BOVENSTAANDE REGEL VERWIJDERD EN LAATSTE DEEL GESPLITST,
C     MARTIN KNOTTERS 21-11-1996
C
      N1=MIN0(N,2000)
      DMEAN=.0
      VAR=.0
      SKEW=.0
      AKURT=.0
      DO 1 I=1,N
    1 DMEAN=DATA(I)+DMEAN
      DMEAN=DMEAN/N
      DO 2 I=1,N
      T1=DATA(I)-DMEAN
      T2=T1*T1
      VAR=VAR+T2
      T3=T2*T1
      SKEW=SKEW+T3
      T4=T3*T1
    2 AKURT=AKURT+T4
      VAR=VAR/N
      STD=SQRT(VAR)
      SKEW=SKEW/(N*STD*VAR)
      AKURT=AKURT/(N*VAR*VAR)-3.
      AMEAN=DMEAN
      AMAX=DATA(1)
      AMIN=DATA(1)
      DO 11 I=1,N
      IF(DATA(I) .GT. AMAX) AMAX=DATA(I)
   11 IF(DATA(I) .LT. AMIN) AMIN=DATA(I)
      RANGE=AMAX-AMIN
      N4=N/4
      N4=MIN0(N4,100)
      DO 13 J=1,N4
      SPDIF(J)=0.
      NJ=N-J
      DO 12 I=1,NJ
   12 SPDIF(J)=(DATA(I)-DMEAN)*(DATA(I+J)-DMEAN)+SPDIF(J)
      JR=N4+1-J
      ACOVF(J)=SPDIF(J)/N
      ACORF(J)=ACOVF(J)/VAR
   13 CONTINUE
      DO 14 J=1,N4
      JR=N4+1-J
      ACOVF(JR+1)=ACOVF(JR)
   14 ACORF(JR+1)=ACORF(JR)
      ACOVF(1)=VAR
      ACORF(1)=1.0
      N4=N4+1
C            WRITE(9,23) DMEAN,VAR,STD,SKEW,AKURT,AMAX,AMIN,RANGE
C   23 FORMAT(1H1,2X,'MEAN = ',F10.4,5X,'VARIANCE (N) = ',F12.0,
C     *       5X,'STANDARD DEVIATION = ',F10.4/
C     *      2X,'SKEWNESS = ',F10.4,5X,'KURTOSIS = ',F10.4/
C     *      2X,'MAXIMUM = ',F10.4,5X,'MINIMUM = ',F10.4,5X,
C     *      'RANGE = ',F10.4)
C      WRITE(9,100)
C  100 FORMAT(1H1/10X,'AUTOCOVARIANCE FUNCTION : '//)
C      WRITE(9,24) (ACOVF(J),J=1,N4)
C   24 FORMAT(/(1X,10F10.4))
C      WRITE(9,101)
C  101 FORMAT(/10X,'AUTOCORRELATION FUNCTION : '//)
C      WRITE(9,25) (ACORF(J),J=1,N4)
C   25 FORMAT(/(1X,10F7.4))
C      CRVAL=60*VALUE
C      WRITE(9,333)
C  333 FORMAT(1H1,2X,'-1.0',25X,'-0.5',25X,'0.0',25X,'0.5',25X,'1.0'/
C     *2X,20('+-----'),'+')
c      DO 300 I=1,N4
c      PACF=ACORF(I)*60
c      IF(PACF .GT. 0) GOTO 301
c      IF(PACF .LT. 0) GOTO 304
c      GOTO 303
c  304 C=61+PACF
c      DO 305 K=C,60
c  305 PLOT(K)=S
c      GOTO 303
c  301 DO 302 J=1,PACF
c      J1=J+61
c  302 PLOT(J1)=S
c  303 M=61-CRVAL
c      MM=61+CRVAL
c      IF(PLOT(M) .EQ. B) PLOT(M)=ONE
c      IF(PLOT(MM) .EQ. B) PLOT(MM)=ONE
C      WRITE(9,306) (PLOT(L),L=1,121)
C  306 FORMAT(2X,121A1)
c      DO 307 II=1,60
c      PLOT(II)=B
c      II1=II+61
c  307 PLOT(II1)=B
c   300 CONTINUE
c      IF(VALUE .EQ. 1.0) GOTO 4
C      WRITE(9,400) VALUE,N
C  400 FORMAT(////'  CRITICAL VALUE = ',F10.4, ' I.E. 1.96/(',
C     1'SQRT(',I5,'))')
c    4 IF(MSPEC .LT.0) RETURN
C     IF(MSPEC .GT. 0) GOTO 3
C     CALL CUTPT(ACORF,N4+1,MSPEC)
C     WRITE(9,901)N4,MSPEC
C 901 FORMAT(' N4 MSPEC =',2I5)
C     GOTO 3
C   3 CALL SPECM(ACOVF,MSPEC,1)
      RETURN
      END
      SUBROUTINE DURAND(SEED,N,X)
C***********************************************************************
C*                                                                     *
C*  FORTRAN CODE WRITTEN FOR INCLUSION IN IBM RESEARCH REPORT RC17097, *
C*  'FORTRAN ROUTINES FOR USE WITH THE METHOD OF L-MOMENTS, VERSION 2' *
C*                                                                     *
C*  J. R. M. HOSKING                                                   *
C*  IBM RESEARCH DIVISION                                              *
C*  T. J. WATSON RESEARCH CENTER                                       *
C*  YORKTOWN HEIGHTS                                                   *
C*  NEW YORK 10598, U.S.A.                                             *
C*                                                                     *
C*  VERSION 2     AUGUST 1991                                          *
C*                                                                     *
C*  VERSION 2.01  FEBRUARY 1993                                        *
C*  * Multiply by RBASE instead of dividing by BASE: 33 percent faster *
C*                                                                     *
C***********************************************************************
C
C  GENERATES A VECTOR OF PSEUDORANDOM NUMBERS UNIFORMLY
C  DISTRIBUTED ON
C  THE INTERVAL (0,1)
C
C  PARAMETERS OF ROUTINE:
C  SEED   *IN/OUT* SEED FOR RANDOM NUMBER GENERATOR. SHOULD BE A
C  WHOLE NUMBER IN THE RANGE 2D0 TO 2147483647D0.
C  N      * INPUT* NUMBER OF NUMBERS TO BE GENERATED
C  X      *OUTPUT* ARRAY OF LENGTH N. ON EXIT, CONTAINS RANDOM
C  NUMBERS.
C
C  METHOD USED: MULTIPLICATIVE CONGRUENTIAL GENERATOR WITH
C  BASE 2**31-1
C  AND MULTIPLIER 7**5 (P.A.W. LEWIS ET AL., 1969, IBM SYSTEMS JOUR-
C  NAL)
C
      IMPLICIT REAL*8 (A-H,O-Z)
C      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION X(1000)
      DATA AMULT/16807D0/
      DATA BASE,RBASE/2147483647D0,4.65661287524579692D-10/
      DO 10 I=1,N
      SEED=DMOD(SEED*AMULT,BASE)
      X(I)=SEED*RBASE
   10 CONTINUE
      RETURN
      END
C
       SUBROUTINE QTHETA(VPH,VPHQ,NREL,THR)
C*** CALCULATE THE QUANTILES OF SAMPLE *************
C
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION VPH(10000,4)
      DIMENSION A4(10000)
      DIMENSION VPHQ(4,7)
      INTEGER THR
C
      NBS=NREL
      DO 10 I1=1,THR
            DO 30 J=1,NBS
               A4(J)=VPH(J,I1)
30          CONTINUE
            K=INT(NBS*.025)
            VPHQ(I1,1)=DFRCTL(A4,NBS,K)
            K=INT(NBS*.05)
            VPHQ(I1,2)=DFRCTL(A4,NBS,K)
            K=INT(NBS*.25)
            VPHQ(I1,3)=DFRCTL(A4,NBS,K)
            K=INT(NBS*.5)
            VPHQ(I1,4)=DFRCTL(A4,NBS,K)
            K=INT(NBS*.75)
            VPHQ(I1,5)=DFRCTL(A4,NBS,K)
            K=INT(NBS*.95)
            VPHQ(I1,6)=DFRCTL(A4,NBS,K)
            K=INT(NBS*.975)
            VPHQ(I1,7)=DFRCTL(A4,NBS,K)
C
10    CONTINUE
      RETURN
      END
C
C  FUNCTION DFRCTL
C  USE: TO FIND THE K TH FRACTILE'S VALUE IN AN UNSORTED ARRAY A(N) BY
C  CALLING A FUNCTION XFRCTL.
C  USAGE: XYZ=XFRCTL(A,N,K)
C  PARAMETERS: ON ENTRY :  A   ARRAY TO INVESTIGATE
C                          N   DIMENSION OF A
C                          K   FRACTILE'S NO. IS BETWEEN 1 AND N.
C**********************************************************************
      REAL*8 FUNCTION DFRCTL(A,N,K)
      IMPLICIT REAL*8 (A-H,O-Z)
      INTEGER R,L,N,K
      DIMENSION A(10000)
C      REAL W,X
C
      IF(N.LE.0)THEN
      DFRCTL=0.0E1
      RETURN
      ELSE IF(K.LE.0) THEN
      K=1
      ELSE IF(K.GT.N) THEN
      K=N
      ENDIF
      L=1
      R=N
10000 CONTINUE
      IF(L.GE.R)GO TO 9000
      X=A(K)
      I=L
      J=R
1000  CONTINUE
      IF(I.GT.J) GO TO 900
100   CONTINUE
      IF(A(I).GE.X)GO TO 200
      I=I+1
      GO TO 100
200   CONTINUE
      IF(X.GE.A(J))GO TO 300
      J=J-1
      GO TO 200
300   CONTINUE
      IF(I.LE.J)THEN
      W=A(I)
      A(I)=A(J)
      A(J)=W
      I=I+1
      J=J-1
      ENDIF
      GO TO 1000
900   CONTINUE
      IF(J.LT.K)L=I
      IF(K.LT.I)R=J
      GO TO 10000
9000  CONTINUE
      DFRCTL=A(K)
      RETURN
      END
C
      SUBROUTINE SIMULA(RMEAN,SV,THD,NTHD,IDM,IARX,IARY,ILAGX,ILAGY,
     *CMATX,N,IES,SSIM,RES,ANORM,NS)
C====================================================================
C====================================================================
C     Transforms input series into output series.
C     XMEAN = mean of output in calibration period. It is used in the
C     starting of the simulation period;
C     N = number of input data;
C     SSIM = seed;
C     NS = number of data in the calibration period, from which the
C     number of residuals is calculated.
C====================================================================
C====================================================================
c      REAL*8 T
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION ANORM(5),SV(1000,2),RE(1000),P(100)
      DIMENSION THD(2,4),CMATX(2,5,32),NTHD(2)
      DIMENSION RES(2,1000),IDM(2)
      DIMENSION NOBS(1)
      DIMENSION IARX(2,5),IARY(2,5),ILAGX(2,50,5),ILAGY(2,50,5)
      INTEGER INDEX(1000)
      DIMENSION PX(1000)
      DIMENSION TRT(100)
      MKY=1
      NTH=NTHD(MKY)
C     WRITE(9,100)
C 100 FORMAT(//'SIMULATED DATA',5x,'INPUT')
      DO 1 II=1,IES
         SV(II,1)=DBLE(RMEAN)
    1 CONTINUE
      NRES=NS-IES+1
      DO 2 I=IES,N
C.....Sorting.
      IP=1
      IF(NTH .EQ. 0) GOTO 3
      ITEST=I-IDM(MKY)
      DO 4 J=1,NTH
C      PRINT*,' IDM(MKY) ',IDM(MKY)
C      PRINT*,' SV(ITEST,1) ',SV(ITEST,1)
C      PRINT*,' THD(MKY,J) ',THD(MKY,J)
      IF(SV(ITEST,1) .GT. THD(MKY,J)) GOTO 4
      IP=J
      GOTO 3
    4 CONTINUE
      IP=NTH+1
    3 CONTINUE
C.....Remember which piece by recording in 'INDEX'
      INDEX(I)=IP
C.....Calculation of fitted residuals:
      NPARM=IARX(MKY,IP)+IARY(MKY,IP)+1
      T=CMATX(MKY,IP,1)
      IF(NPARM .LT. 2) GOTO 8
C.....Create vectors P, containing values of the predictor variables at
C.....a time step:
      DO 10 JX=1,IARX(MKY,IP)
         IM=ILAGX(MKY,JX,IP)
         P(JX+1)=SV(I-IM,1)
   10 CONTINUE
      DO 11 JY=1,IARY(MKY,IP)
         JJS=JY+IARX(MKY,IP)+1
         IM=ILAGY(MKY,JY,IP)
         P(JJS)=SV(I-IM,2)
   11 CONTINUE
C.....Calculate fitted values:
      DO 5 K=2,NPARM
    5 T=DBLE(CMATX(MKY,IP,K))*DBLE(P(K))+T
C.....Deterministic simulation:
    8 SV(I,1)=T
C.....Resample from standardized fitted residuals:
      CALL DURAND(SSIM,1,RE)
C      PRINT*,' RE ',RE
C      PRINT*,' NRES ',NRES
      IRP=1+INT(NRES*RE(1))
C      PRINT*,' IRP ',IRP
C      PRINT*,' RES(MKY,IRP) ',RES(MKY,IRP)
C      PRINT*,' IP ',IP
C      PRINT*,' ANORM(IP) ',ANORM(IP)
C.....Add resampled destandardized residual to the deterministic 
C.....simulation to obtain a stochastic simulation:
      SV(I,1)=SV(I,1)+DBLE(RES(MKY,IRP))*ANORM(IP)
C****************************************************************
C      Modification by M. Knotters.
C      If the groundwater level reaches the groundsurface, the 
C      simulated water-table depth is set to zero !!!!
C****************************************************************
       IF (SV(I,1).GT.0.) THEN
          SV(I,1)=0.
       ENDIF
C****************************************************************
C      PRINT*,' SV ',SV(I,1)
C.....Writing simulated data:
C      WRITE(9,101)SV(I,1),SV(I,2),RES(MKY,IRP),ANORM(IP)
C  101 FORMAT(4f10.4)
    2 CONTINUE
      RETURN
      END
c#####################################################
c Quicksort routine from numerical recipes
c#####################################################
      SUBROUTINE QCKSRT(N,ARR)
      IMPLICIT REAL*8 (A-H,O-Z)
      PARAMETER (M=7,NSTACK=50,FM=7875.,FA=211.,FC=1663.
     *    ,FMI=1.2698413E-4,maxdat=800000)
      DIMENSION ISTACK(NSTACK)
      DIMENSION ARR(maxdat)
C     DOUBLE PRECISION A
      JSTACK=0
      L=1
      IR=N
      FX=0.
10    IF(IR-L.LT.M)THEN
        DO 13 J=L+1,IR
          A=ARR(J)
          DO 11 I=J-1,1,-1
            IF(ARR(I).LE.A)GO TO 12
            ARR(I+1)=ARR(I)
11        CONTINUE
          I=0
12        ARR(I+1)=A
13      CONTINUE
        IF(JSTACK.EQ.0)RETURN
        IR=ISTACK(JSTACK)
        L=ISTACK(JSTACK-1)
        JSTACK=JSTACK-2
      ELSE
        I=L
        J=IR
        FX=MOD(FX*FA+FC,FM)
        IQ=L+(IR-L+1)*(FX*FMI)
        A=ARR(IQ)
        ARR(IQ)=ARR(L)
20      CONTINUE
21        IF(J.GT.0)THEN
            IF(A.LT.ARR(J))THEN
              J=J-1
              GO TO 21
            ENDIF
          ENDIF
          IF(J.LE.I)THEN
            ARR(I)=A
            GO TO 30
          ENDIF
          ARR(I)=ARR(J)
          I=I+1
22        IF(I.LE.N)THEN
            IF(A.GT.ARR(I))THEN
              I=I+1
              GO TO 22
            ENDIF
          ENDIF
          IF(J.LE.I)THEN
            ARR(J)=A
            I=J
            GO TO 30
          ENDIF
          ARR(J)=ARR(I)
          J=J-1
        GO TO 20
30      JSTACK=JSTACK+2
        IF(JSTACK.GT.NSTACK)PAUSE 'NSTACK must be made larger.'
        IF(IR-I.GE.I-L)THEN
          ISTACK(JSTACK)=IR
          ISTACK(JSTACK-1)=I+1
          IR=I-1
        ELSE
          ISTACK(JSTACK)=I-1
          ISTACK(JSTACK-1)=L
          L=I+1
        ENDIF
      ENDIF
      GO TO 10
      END
      SUBROUTINE PERCEN(P,SARR,NREL,PERC)
C======================================================================
C======================================================================
C Calculates percentiles by linear interpolation.
C======================================================================
C======================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION SARR(1000)
C      DOUBLE PRECISION PERC,PLO,PUP,RDF
      RDF=1+(NREL-1)*P
      IDU=IDINT(RDF)
      PLO=SARR(IDU)
      IF (IDU .EQ. NREL) THEN
         PERC=PLO
      ELSE
         IDU1=IDU+1
         PUP=SARR(IDU1)
         RIDU=DBLE(IDU)
         PERC=PLO+(RDF-RIDU)*(PUP-PLO)
      ENDIF
      RETURN
      END
      SUBROUTINE PCAND(X,N,CTHD,IPL,IPU)
C==============================================================
C==============================================================
C Martin Knotters, May 1997.
C Defines candidate threshold values for water-table depths.
C The threshold values are at intervals of 1 cm in a
C user-supplied interpercentile range. 
C X : the matrix of data;
C N : the number of data;
C CTHD : the matrix of candidate threshold values;
C IPL : the user-supplied lower percentile;
C IPU : the user-supplied upper percentile.
C Subroutine called: QCKSRT.
C==============================================================
C==============================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      REAL*8 IPL,IPU
      DIMENSION X(2,1000),CTHD(2,300),SARR(1000)
      DO I=1,N
          SARR(I)=X(1,I)
      ENDDO
      CALL QCKSRT(N,SARR)
      IP=NINT(IPL*N)
      AMIN=SARR(IP)
      IP=NINT(IPU*N)
      AMAX=SARR(IP)
      I=INT(AMAX-AMIN)
      DO 12 K=1,2
         CTHD(K,1)=REAL(INT(AMIN))
         DO 13 J=2,I
            CTHD(K,J)=CTHD(K,J-1)+1
   13    CONTINUE
   12 CONTINUE
      RETURN
      END
